#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

ByTe_4 SetTrac(struct fh_cache *fh, ByTe_2 Sen, ByTe_2 Col, ByTe_2 aN, 
               ByTe_2 Item)
{
   struct Pidf         *P;
   struct PidfSensor   *Px;
   struct PidfAnc      *Pa;

   ByTe_4 Start, Pos;
   ByTe_4 Len, vN;
   ByTe_1 *c1;

   switch (Item)
   {
      case 0:                                                   /* D_Qual */
        Start = Col + Sen * fh->NCols;
        Start *= sizeof (float);
      break;

      case 1:                                                  /* Azimuth */
        if (fh->flags.azimuth == 0) {
            Start = (Sen == 0 && Col == 0) ? 0 : -1;
        } else {
            Start = Sen * fh->maxlen * fh->NCols + Col * fh->maxlen;
        }
        Start *= sizeof (float);
      break;

      case 2:                                                  /* Theta   */
        if (fh->flags.theta == 0) {
            Start = Col + Sen * fh->NCols;
        } else {
            Start = Sen * fh->maxlen * fh->NCols + Col * fh->maxlen;
        }
        Start *= sizeof (float);
      break;

      case 3:                                                  /* ArIndex */
        if (fh->sample_id == 2) {
            Start = -1;
        } else {
            if (fh->flags.indices == 0) {
               Start = (Sen == 0 && Col == 0) ? aN * fh->maxlen : -1;
           } else {
               Start = fh->TotIndex * Sen * fh->maxlen * fh->NCols + 
                       Col * fh->maxlen + aN * fh->maxlen * fh->NCols;
           }
        }
        Start *= sizeof (float);
      break;

      case 4:                                                    /* Data  */
        Start = Sen * fh->maxlen * fh->NCols + Col * fh->maxlen;
        Start *= (fh->sType == IDL_TYP_FLOAT) ? sizeof(ReaL_4) : 
                                                 sizeof (ReaL_8);
      break;

      case 5:                                                    /* Anc   */
        P = (struct Pidf *)fh->PIDF;
        Px = (struct PidfSensor *)P->Sensors;
        Pa = (struct PidfAnc *)P->Ancil;
        c1 = (ByTe_1 *)fh->AncInfo + fh->nanc * sizeof(ByTe_2);
        Pos = fh->TotVSen + aN;

        vN = (*(fh->Loc + Pos) == 'S') ? Px[*(fh->Order + Pos)].VidfNum :
                                         Pa[*(fh->Order + Pos)].VidfNum;

        switch (*(c1 + vN)) {
           case 0:
           case 1:
             Len = (*(fh->Dim + Pos) == 0) ? 1 : fh->maxlen; 
             Start = Sen * Len * fh->NCols + Col * Len;
           break;
           case 2:
             Start = (Sen == 0) ? Col : -1;
           break;
           case 3:
             Start = (Sen == 0 && Col == 0) ? 0 : -1;
           break;
        }
        Start *= (fh->sType == IDL_TYP_FLOAT) ? sizeof(float) : 
                                                 sizeof (double);
      break;
   }

   return (Start);
}
