#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "PidfStr.h"
#include "PidfAnsi.h"

#include "udfdlm_ansi.h"
#include "udfdlm_str.h"

void SetOrder (ByTe_2 Item, struct fh_cache *fh)
{
   struct Pidf *P;
   struct PidfSensor *Px;
   struct PidfAnc *Pa;

   register ByTe_2 *s1, *s2;
   register ByTe_1 *c1, *c2, *c3;

   ByTe_4 M, N, aV;
   ByTe_4 NSAnc = 0, Pos;

   P = (struct Pidf *)fh->PIDF;
   Px = (struct PidfSensor *)P->Sensors;
   Pa = (struct PidfAnc *)P->Ancil;

   switch (Item) {
      case SENSOR:
         s1 = fh->Order;
         c1 = fh->uNDef;
         fh->TotVSen = 0;
         switch (fh->flags.sformat) {
            case 2:
              for (M=0; M < P->Ps.NGroups; M++) {
                  for (N=0; N < P->Ps.NSensors; N++) {
                     if (Px[N].Src == 'V' && Px[N].GroupNum == M) {
                         fh->TotVSen += 1;
                         *s1++ = N;
                         if (RetNumUnits (fh, N, 'S') == 2)
                         {
                            *c1++ = 1;
                            *c1++ = 2;
                            fh->TotVSen += 1;
                            *s1++ = N;
                         }
                         else
                            *c1++ = 0;
                     }
                 }
              }
            break;
            default:
              for (N=0; N < P->Ps.NSensors; N++) {
                 if (Px[N].Src == 'V') {
                     fh->TotVSen += 1;
                     *s1++ = N;
                     if (RetNumUnits (fh, N, 'S') == 2)
                     {
                        *c1++ = 1;
                        *c1++ = 2;
                        fh->TotVSen += 1;
                        *s1++ = N;
                     }
                     else
                        *c1++ = 0;
                 }
              }
            break;
         }
      break;

      case ANCILLARY:
         s1 = fh->Order + fh->TotVSen;
         c1 = fh->Loc + fh->TotVSen;
         c2 = fh->Set + fh->TotVSen;
         c3 = fh->uNDef + fh->TotVSen;
         fh->TotAnc = 0;

         for (N=0; N <P->Ps.NSensors; N++) {
            if (Px[N].Src == 'A') {
               fh->TotAnc += 1;
               *c1++ = 'S';
               *c2++ = Px[N].VidfNum;
               *s1++ = Px[N].PidfNum;
               if (RetNumUnits (fh, N, 'S') == 2)
               {
                  *c1++ = 'S';
                  *c2++ = Px[N].VidfNum;
                  *c3++ = 1;
                  *c3++ = 2;
                  *s1++ = Px[N].PidfNum;
                  fh->TotAnc += 1;
               }
               else
                  *c3++ = 0;
            }
         }

         NSAnc = fh->TotAnc;
         for (N=0; N <P->Ps.NAncils; N++) {
            aV = Pa[N].VidfNum;
            s2 = fh->Order + fh->TotVSen;
            for (M = 0; M < NSAnc; ++M) {
               if (aV == Px[*s2++].VidfNum)
                  break;
            }

            if (M == NSAnc) {
               fh->TotAnc += 1;
               *c1++ = 'A';
               *c2++ = Pa[N].VidfNum;
               *s1++ = Pa[N].PidfNum;
               if (RetNumUnits (fh, N, 'A') == 2)
               {
                  *c1++ = 'S';
                  *c2++ = Px[N].VidfNum;
                  *c3++ = 1;
                  *c3++ = 2;
                  *s1++ = Px[N].PidfNum;
                  fh->TotAnc += 1;
               }
               else
                  *c3++ = 0;
            }
         }
      break;
      case MODE:
         Pos = fh->TotVSen + fh->TotAnc;
         s1 = fh->Order + Pos;
         c1 = fh->uNDef + Pos;
         fh->TotMode = 0;
         for (N=0; N < P->Ps.NModes; N++) {
             fh->TotMode += 1;
             *s1++ = N;
             if (RetNumUnits (fh, N, 'M') == 2)
             {
                *c1++ = 1;
                *c1++ = 2;
                fh->TotMode += 1;
                *s1++ = N;
             }
             else
                *c1++ = 0;
         }
      break;
      case SCAN_INDEX:
         if (fh->sample_id != 2)
         {
            Pos = fh->TotVSen + fh->TotAnc + fh->TotMode;
            s1 = fh->Order + Pos;
            c1 = fh->uNDef + Pos;
            fh->TotIndex = 1;
            *s1++ = 0;
            if (RetNumUnits (fh, 0, 'I') == 2)
            {
                *c1++ = 1;
                *c1++ = 2;
                fh->TotIndex += 1;
                *s1++ = 0;
            }
             else
                *c1++ = 0;
         }
         else
            fh->TotIndex = 0;
      break;
   }
}
