#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void SetDims(struct fh_cache *fh, ByTe_4 *D, ByTe_1 Item, ByTe_4 NuM)
{
   ByTe_4 kW;
   struct Pidf         *P;
   struct PidfSensor   *Px;
   struct PidfAnc      *Pa;

   register ByTe_4 *l1;
   register ByTe_2 *s1;
   ByTe_4 N, vN, Len, pN, Pos, nS;
   ByTe_1 *c1;

   l1 = D;
   N = *l1;
   *l1++ = 0;
   *l1++ = 0;
   *l1 = 0;
   l1 = D;

   switch (Item)
   {
      case 0:                                                    /* Azimuth */
      case 2:                                                    /* ArIndex */
        kW = (Item == 0) ? fh->flags.azimuth : fh->flags.indices;
        if (kW == 0)
           *l1 = fh->maxlen;
        else {
           if (fh->NCols == 1)
           {
              *l1++ = fh->maxlen;
              *l1 = fh->TotVSen;
           } else {
              *l1++ = fh->maxlen;
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        }
      break;
      case 1:                                                    /* Theta */
        if (fh->flags.theta == 0 || fh->maxlen == 1)
        {
           if (fh->NCols == 1)
              *l1 = fh->TotVSen;
           else { 
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        } else {
           if (fh->NCols == 1) {
              *l1++ = fh->maxlen;
              *l1 = fh->TotVSen;
           } else {
              *l1++ = fh->maxlen;
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        }
      break;
      case 3:                                            /* Collapse Data */
        if (fh->maxlen == 1)
           *l1 = fh->TotVSen;
        else {
           if (fh->NCols == 1) {
              *l1++ = fh->maxlen;
              *l1 = fh->TotVSen;
           } else {
              *l1++ = fh->maxlen;
              *l1++ = fh->NCols;
              *l1 = fh->TotVSen;
           }
        }
      break;
      case 5:                                             /* Data */
        switch (fh->flags.sformat) {
           case 1:                                        /* Data: Collapse */
             if (fh->TotVSen == 1 && fh->NCols) {
                *l1 = fh->maxlen;
             } else {
                *l1++ = fh->maxlen;
                *l1 =  fh->TotVSen * fh->NCols;
             }
           break;
           case 2:                                        /* Data: Group    */
              P = (struct Pidf *)fh->PIDF;
              Px = (struct PidfSensor *)P->Sensors;
              nS = 0;
              s1 = fh->Order;
              for (N=0; N < fh->TotVSen; ++N, ++Px) {
                  if (Px->GroupNum == NuM)
                     ++nS;
              }

             if (nS > 0) {
                if (nS == 1 && fh->NCols == 1) {
                   *l1 = fh->maxlen;
                } else {
                   *l1++ = fh->maxlen;
                   *l1 =  nS * fh->NCols;
                }
             } else
               *l1 = -1;
           break;
           default:                                       /* Data: Standard */
             if (fh->NCols == 1) {
                *l1 = fh->maxlen;
             } else {
                *l1++ = fh->maxlen;
                *l1 = fh->NCols;
             }
           break;
        }
    
      break;
      case 6:                                             /* D_Qual Data */
        if (fh->NCols == 1) {
           *l1 = fh->TotVSen;
        } else {
           *l1++ = fh->TotVSen;
           *l1 = fh->NCols;
        }
      break;
      case 7:                                               /* Mode  Data */
        *l1 = 1;
      break;
      case 8:                                               /* Anc  Data */
        P = (struct Pidf *)fh->PIDF;
        Px = (struct PidfSensor *)P->Sensors;
        Pa = (struct PidfAnc *)P->Ancil;
        s1 = (ByTe_2 *)fh->AncInfo;
        c1 = (ByTe_1 *)fh->AncInfo + fh->nanc * sizeof(ByTe_2);

        Pos = fh->TotVSen + N;
        pN = *(fh->Order + Pos);
        vN = (*(fh->Loc + Pos) == 'S') ? Px[pN].VidfNum : Pa[pN].VidfNum;

        switch (*(c1 + vN)) {                               /* by target  */
           case 0:
           case 1:
             Len = (*(s1 + vN) == 0) ? 1 : fh->maxlen;
             *(fh->Dim + Pos) = (Len == 1) ? 0 : 1;
             if (fh->NCols == 1)
             {
                if (Len == 1) {
                   *l1 = fh->TotVSen;
                }
                else {
                   *l1++ = Len;
                   *l1 = fh->TotVSen;
                }
             } else {
                if (Len == 1) {
                   *l1++ = fh->NCols;
                   *l1 = fh->TotVSen;
                }
                else {
                   *l1++ = Len;
                   *l1++ = fh->NCols;
                   *l1 = fh->TotVSen;
                }
             }
           break;
           case 2:
             *l1 = fh->NCols;
             *(fh->Dim + Pos) = 0;
           break;
           case 3:
             *l1 = 1;
             *(fh->Dim + Pos) = 0;
           break;
        }

      break;
   }
}
