#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void RetUnit (struct fh_cache *fh, ByTe_2 Num, ByTe_1 Loc, ByTe_2 *uN1, 
              ByTe_2 *uN2)
{
   register ByTe_4 *l1;
   register ByTe_2 *s1, *s2;
   register ByTe_1 *c1;

   struct Pidf *P;
   struct PidfSensor *Px;
   struct PidfMode   *Pm;
   struct PidfAnc    *Pa;
   struct PidfScan   *Pi;

   ByTe_4 N, B, Nunits;

   P = (struct Pidf *)fh->PIDF;

   *uN1 = (fh->flags.baseunit == 0) ? 0 : 1000;
   *uN2 = -1;

   B = sizeof (ByTe_4);
   l1 = (ByTe_4 *)fh->pInfo;
   s1 = (ByTe_2 *)((ByTe_1 *)fh->pInfo + fh->tV * B);
   B += sizeof (ByTe_2);
   s2 = (ByTe_2 *)((ByTe_1 *)fh->pInfo + fh->tV * B);
   B += sizeof (ByTe_2);
   c1 = (ByTe_1 *)((ByTe_1 *)fh->pInfo + fh->tV * B);

   for (N = 0; N < fh->tV; ++N, ++l1, ++s1, ++s2, ++c1) {
      if (*l1 == Num && *c1 == Loc) {
         *uN1 = *s1;
         *uN2 = (*s1 == *s2) ? -1 : *s2;
         break;
      }
   }

   switch (Loc) {
       case 'S':
         Px = (struct PidfSensor *)P->Sensors + Num;
         Nunits = Px->NUnits;
         s1 = Px->Units;
       break;
       case 'M':
         Pm = (struct PidfMode *)P->Modes + Num;
         Nunits = Pm->NUnits;
         s1 = Pm->Units;
       break;
       case 'A':
         Pa = (struct PidfAnc *)P->Ancil + Num;
         Nunits = Pa->NUnits;
         s1 = Pa->Units;
       break;
       case 'I':
         Pi = (struct PidfScan *)P->Scans + Num;
         Nunits = Pi->NUnits;
         s1 = Pi->Units;
       break;
   }

   if (Nunits < 1)
      idl_barf("Bad Number Of Units: Measurement %c %d", Loc, Num);

   if (*uN1 >= Nunits)  *uN1 = Nunits - 1;
   *uN1 = *(s1 + *uN1);
   if (*uN2 >= 0)
      *uN2 = *(s1 + *uN2);

   if (*uN1 >= P->Ps.NUnits)
      idl_barf("Whoops Measurement %d: Unit(%d) > max!", Num, *uN1);
   if (*uN2 >= P->Ps.NUnits)
      idl_barf("Whoops Measurement %d: Unit(%d) > max!", Num, *uN2);
}
