package provide UDFUnits 1.0
                                                                                
proc uURdPidf { } {
   global uUANS Pidf0

   if $uUANS(DefMenu) { return }
   set uList [list P M E I V]
   for { set I 0 } { $I < 5 } { incr I } {
      if { [string length $uUANS(0,[lindex $uList $I])] == 0 } { return }
   }

   set uUANS(DefMenu) 1
   set PmeiV [list $uUANS(0,P) $uUANS(0,M) $uUANS(0,E) $uUANS(0,I) $uUANS(0,V)]
   set KeY [GetDataKey $PmeiV]
   if { [ReadPIDF $KeY] < 0 } { return "" }

   set W .inMAIN.right

   GUILabel $W.senL "SENSORS" center grid|0|0|news 10 0 #FF0000
   GUILabel $W.modesL "MODES" center grid|0|1|news 10 0 #FF0000
   GUILabel $W.ancsL "ANCILLARY" center grid|0|2|news 10 0 #FF0000
   GUILabel $W.scanL "ARRAY INDEX" center grid|0|3|news 10 0 #FF0000

   set CnT  0
   set uUANS(PidfN) ""
   set uUANS(MType) ""

   set TPgs [expr int ($Pidf0(NSens) / $uUANS(MaxPerPg))] 
   set Rem [expr $Pidf0(NSens) % $uUANS(MaxPerPg)] 
   if {$Rem == 0 } {incr TPgs -1 }

   set J 0
   for {set M 0 ; set R 1 } { $M <= $TPgs } {incr M ; incr R } {
      set pN .pg$uUANS(PaGeS)
      toplevel $pN
      set Lab "Page $M"
      wm title $pN $Lab
      wm withdraw $pN 

      GUIFrame $pN.top -1 pack|top||both|true
      GUIFrame $pN.main -1 pack|top||both|true

      GUIbuttonPush $W$pN $Lab grid|$R|0|news "wm deiconify $pN" 10
      GUIbuttonPush $pN.top.close CLOSE pack|right "wm withdraw $pN"  10

      set I 0
      while {($I < $uUANS(MaxPerPg)) && ($J < $Pidf0(NSens))} {
         set wNa $pN.main.l$I
         set wNb $pN.main.b$I
         set wNc $pN.main.c$I
         GUILabel $wNa [lindex $Pidf0(SenName) $J] center grid|$I|0|w
         set uD uD$CnT
         set dP(0) A2 ; set dP(1) $J
         set uNames [GUpidfLists $PmeiV Munits dP]
         GUIbuttonMenu $wNb "" grid|$I|1|news $uNames \
             "GUIoptsProcess $wNb uUANS($uD.A) ALT " 1 -1
         GUIbuttonMenu $wNc "" grid|$I|2|news $uNames \
             "GUIoptsProcess $wNc uUANS($uD.B) ALT " 1 -1

         if !$uUANS(DefU) {
            set uN 0
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         } else {
            set uN [expr [llength $uNames] - 1] 
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         }
         set uUANS($uD.A) [lindex [split [lindex $uNames $uN] "|"] 1] 
         set uUANS($uD.B) [lindex [split [lindex $uNames $uN] "|"] 1] 

         $wNb configure -text $Lab -font default
         $wNc configure -text $Lab -font default
         lappend uUANS(PidfN) $J
         lappend uUANS(MType) S

         incr I
         incr J
         incr CnT
      }
      incr uUANS(PaGeS)
   }

   set TPgs [expr int ($Pidf0(NModes) / $uUANS(MaxPerPg))] 
   set Rem [expr $Pidf0(NModes) % $uUANS(MaxPerPg)] 
   if {$Rem == 0 } {incr TPgs -1 }

   set J 0
   for {set M 0 ; set R 1 } { $M <= $TPgs } {incr M ; incr R } {
      set pN .pg$uUANS(PaGeS)
      toplevel $pN
      set Lab "Page $M"
      wm title $pN $Lab
      wm withdraw $pN 

      GUIFrame $pN.top -1 pack|top||both|true
      GUIFrame $pN.main -1 pack|top||both|true

      GUIbuttonPush $W$pN $Lab grid|$R|1|news "wm deiconify $pN" 10
      GUIbuttonPush $pN.top.close CLOSE pack|right "wm withdraw $pN"  10

      set I 0
      while {($I < $uUANS(MaxPerPg)) && ($J < $Pidf0(NModes))} {
         set wNa $pN.main.l$I
         set wNb $pN.main.b$I
         set wNc $pN.main.c$I
         GUILabel $wNa [lindex $Pidf0(ModeName) $J] center grid|$I|0|w
         set uD uD$CnT
         set dP(0) A1 ; set dP(1) $J
         set uNames [GUpidfLists $PmeiV Munits dP]
         GUIbuttonMenu $wNb "" grid|$I|1|news $uNames \
             "GUIoptsProcess $wNb uUANS($uD.A) ALT " 1 -1
         GUIbuttonMenu $wNc "" grid|$I|2|news $uNames \
             "GUIoptsProcess $wNc uUANS($uD.B) ALT " 1 -1

         if !$uUANS(DefU) {
            set uN 0
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         } else {
            set uN [expr [llength $uNames] - 1] 
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         }
         set uUANS($uD.A) [lindex [split [lindex $uNames $uN] "|"] 1] 
         set uUANS($uD.B) [lindex [split [lindex $uNames $uN] "|"] 1] 

         $wNb configure -text $Lab -font default
         $wNc configure -text $Lab -font default
         lappend uUANS(PidfN) $J
         lappend uUANS(MType) M

         incr I
         incr J
         incr CnT
      }
      incr uUANS(PaGeS)
   }


   set TPgs [expr int ($Pidf0(NAncs) / $uUANS(MaxPerPg))] 
   set Rem [expr $Pidf0(NAncs) % $uUANS(MaxPerPg)] 
   if {$Rem == 0 } {incr TPgs -1 }

   set J  0
   for {set M 0 ; set R 1 } { $M <= $TPgs } {incr M ; incr R } {
      set pN .pg$uUANS(PaGeS)
      toplevel $pN
      set Lab "Page $M"
      wm title $pN $Lab
      wm withdraw $pN 

      GUIFrame $pN.top -1 pack|top||both|true
      GUIFrame $pN.main -1 pack|top||both|true

      GUIbuttonPush $W$pN $Lab grid|$R|2|news "wm deiconify $pN" 10
      GUIbuttonPush $pN.top.close CLOSE pack|right "wm withdraw $pN"  10

      set I 0
      while {($I < $uUANS(MaxPerPg)) && ($J < $Pidf0(NAncs))} {
         set wNa $pN.main.l$I
         set wNb $pN.main.b$I
         set wNc $pN.main.c$I
         GUILabel $wNa [lindex $Pidf0(AncName) $J] center grid|$I|0|w
         set uD uD$CnT
         set dP(0) A0 ; set dP(1) $J
         set uNames [GUpidfLists $PmeiV Munits dP]
         GUIbuttonMenu $wNb "" grid|$I|1|news $uNames \
             "GUIoptsProcess $wNb uUANS($uD.A) ALT " 1 -1
         GUIbuttonMenu $wNc "" grid|$I|2|news $uNames \
             "GUIoptsProcess $wNc uUANS($uD.B) ALT " 1 -1

         if !$uUANS(DefU) {
            set uN 0
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         } else {
            set uN [expr [llength $uNames] - 1] 
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         }
         set uUANS($uD.A) [lindex [split [lindex $uNames $uN] "|"] 1] 
         set uUANS($uD.B) [lindex [split [lindex $uNames $uN] "|"] 1] 

         $wNb configure -text $Lab -font default
         $wNc configure -text $Lab -font default
         lappend uUANS(PidfN) $J
         lappend uUANS(MType) A

         incr I
         incr J
         incr CnT
      }
      incr uUANS(PaGeS)
   }

   set TPgs [expr int ($Pidf0(NScans) / $uUANS(MaxPerPg))] 
   set Rem [expr $Pidf0(NScans) % $uUANS(MaxPerPg)] 
   if {$Rem == 0 } {incr TPgs -1 }

   set J  0
   for {set M 0 ; set R 1 } { $M <= $TPgs } {incr M ; incr R } {
      set pN .pg$uUANS(PaGeS)
      toplevel $pN
      set Lab "Page $M"
      wm title $pN $Lab
      wm withdraw $pN 

      GUIFrame $pN.top -1 pack|top||both|true
      GUIFrame $pN.main -1 pack|top||both|true

      GUIbuttonPush $W$pN $Lab grid|$R|3|news "wm deiconify $pN" 10
      GUIbuttonPush $pN.top.close CLOSE pack|right "wm withdraw $pN"  10

      set I 0
      while {($I < $uUANS(MaxPerPg)) && ($J < $Pidf0(NScans))} {
         set wNa $pN.main.l$I
         set wNb $pN.main.b$I
         set wNc $pN.main.c$I
         GUILabel $wNa "Array Index" center grid|$I|0|w
         set uD uD$CnT
         set dP(0) $J
         set uNames [GUpidfLists $PmeiV Iunits dP]
         GUIbuttonMenu $wNb "" grid|$I|1|news $uNames \
             "GUIoptsProcess $wNb uUANS($uD.A) ALT " 1 -1
         GUIbuttonMenu $wNc "" grid|$I|2|news $uNames \
             "GUIoptsProcess $wNc uUANS($uD.B) ALT " 1 -1

         if !$uUANS(DefU) {
            set uN 0
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         } else {
            set uN [expr [llength $uNames] - 1] 
            set Lab [lindex [split [lindex $uNames $uN] "|"] 0] 
         }
         set uUANS($uD.A) [lindex [split [lindex $uNames $uN] "|"] 1] 
         set uUANS($uD.B) [lindex [split [lindex $uNames $uN] "|"] 1] 

         $wNb configure -text $Lab -font default
         $wNc configure -text $Lab -font default
         lappend uUANS(PidfN) $J
         lappend uUANS(MType) I

         incr I
         incr J
         incr CnT
      }
      incr uUANS(PaGeS)
   }

   set uUANS(TotItems) $CnT
}
