#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void ConvTheta (struct fh_cache *fh, ByTe_1 *Base, ByTe_2 N, ByTe_2 M)
{
   extern void *UDF;

   struct idf_data    *U;

   ByTe_4 TracOff;
   ByTe_4 NTheta;

   ByTe_1 *trac, Prec;


   U = (struct idf_data *)UDF;
   Prec = sizeof(ReaL_4);

   TracOff = SetTrac (fh, N, M, 0, 2);
   trac = Base + fh->Begs[_BTHETA_] + TracOff;
   NTheta = (fh->flags.theta == 0) ? 1 : U->num_sample;
   CopyMem (trac, (void *)U->start_theta, NTheta, Prec);
   trac = Base + fh->Begs[_ETHETA_] + TracOff;
   CopyMem (trac, (void *)U->stop_theta, NTheta, Prec);
}
