#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void ConvSensor (struct fh_cache *fh, ByTe_1 *Base, ByTe_2 N, ByTe_2 Col)
{
   extern u_ByTe_2 Version;
   extern ByTe_1 Ext[];
   extern void *UDF;
   extern void *TmpSpace;

   struct Pidf        *P;
   struct PidfUnit    *Pu;
   struct idf_data    *U;

   ReaL_4 *f1;
   ByTe_2 sU;
   ByTe_2 rV;
   ByTe_1 DataField, Prec;

   ByTe_1 *trac;

   P = (struct Pidf *)fh->PIDF;
   Pu = (struct PidfUnit *)P->Units;
   U = (struct idf_data *)UDF;
   
   trac = Base + fh->Begs[_SENSOR_] + SetTrac (fh, N, Col, 0, 4);
   sU = *(fh->Units + N);
   DataField =  (fh->sType == IDL_TYP_DOUBLE) ? DSENSOR : SENSOR;
   Prec = (fh->sType == IDL_TYP_DOUBLE) ? sizeof(ReaL_8) : sizeof(ReaL_4);
   rV = convert_to_units(fh->Key, Ext, Version, UDF, DataField,
                         0, (ByTe_1)Pu[sU].NTbls, Pu[sU].Tbls, 
                         Pu[sU].Ops, (ReaL_4*)TmpSpace, 0, 0);
   if (rV != ALL_OKAY)
      udf_barf("ConvertToUnits(SENSOR)", rV);
   CopyMem (trac, TmpSpace, (ByTe_4)U->num_sample, Prec);
}
