#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void ConvIndex (struct fh_cache *fh, ByTe_1 *Base, ByTe_2 N, ByTe_2 M)
{
   extern void *UDF;
   extern void *TmpSpace;
   extern u_ByTe_2 Version;
   extern ByTe_1 Ext[];

   struct Pidf        *P;
   struct PidfUnit    *Pu;
   struct idf_data    *U;

   ByTe_4 I;
   ByTe_2 *s1;
   ByTe_2 rV, iU;

   ByTe_1 *trac, Prec;

   P = (struct Pidf *)fh->PIDF;
   Pu = (struct PidfUnit *)P->Units;
   U = (struct idf_data *)UDF;
   Prec = sizeof(ReaL_4);

   if (SetTrac (fh, N, M, 0, 3) >= 0)
   {
      s1 = fh->Units + fh->TotVSen + fh->TotAnc + fh->TotMode;
      for (I = 0; I < fh->TotIndex; ++I) {
         iU = *s1++;
         trac = Base + fh->Begs[_INDEX_] + SetTrac (fh, N, M, I, 3);
         rV = convert_to_units(fh->Key, Ext, Version, UDF, SCAN_INDEX,
                               0, (ByTe_1)Pu[iU].NTbls, Pu[iU].Tbls,
                               Pu[iU].Ops, (ReaL_4*)TmpSpace, 0, 0);
         if (rV != ALL_OKAY)
            udf_barf("ConvertToUnits(SCAN)", rV);
         CopyMem (trac, TmpSpace, (ByTe_4)U->num_sample, Prec);
      }
   }
}
