#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#ifdef _IDL_EXPORT_
#include "idl_export.h"
#else
#include "export.h"
#endif

#include "user_defs.h"
#include "ret_codes.h"
#include "libbase_udf.h"
#include "PidfAnsi.h"
#include "PidfStr.h"
#include "PidfRets.h"

#include "udfdlm_defs.h"
#include "udfdlm_ansi.h"

void ConvAnc (struct fh_cache *fh, ByTe_1 *Base, ByTe_2 SeN, ByTe_2 Col)
{
   extern u_ByTe_2 Version;
   extern ByTe_1   Ext[];
   extern void     *UDF;
   extern void     *TmpSpace;

   struct Pidf        *P;
   struct PidfUnit    *Pu;
   struct idf_data    *U;

   ByTe_4 TracOff;
   ByTe_2 aU, I, L = _ANC_;
   ByTe_2 rV, *s1;
   ByTe_1 DataField;
   ByTe_1 *c1, *c2;
   ByTe_1 *trac, Prec;

   P = (struct Pidf *)fh->PIDF;
   Pu = (struct PidfUnit *)P->Units;
   U = (struct idf_data *)UDF;

   DataField = (fh->sType == IDL_TYP_DOUBLE) ? DANCILLARY : ANCILLARY;
   Prec = (fh->sType == IDL_TYP_DOUBLE) ? sizeof(ReaL_8) : sizeof(ReaL_4);
   c1 = fh->Set + fh->TotVSen;
   c2 = fh->Dim + fh->TotVSen;
   s1 = fh->Units + fh->TotVSen;

   for (I = 0; I < fh->TotAnc; ++I, ++L, ++c1, ++c2, ++s1)
   {
      if ((TracOff = SetTrac (fh, SeN, Col, I, 5)) >= 0) {
         trac = Base + fh->Begs[L] + TracOff;
         aU = *s1;
         rV = convert_to_units(fh->Key, Ext, Version, UDF, DataField,
                               *c1, (ByTe_1)Pu[aU].NTbls, Pu[aU].Tbls, 
                               Pu[aU].Ops, (ReaL_4*)TmpSpace, 0, 0);

         if (*c2 == 0)
            CopyMem (trac, TmpSpace, 1, Prec);
         else
            CopyMem (trac, TmpSpace, (ByTe_4)U->num_sample, Prec);

         if (rV != ALL_OKAY)
            udf_barf("ConvertToUnits(ANC)", rV);
      }
   }
}
