#include <string.h>
#include "OpSySInD.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

  /**************************************************************************/
  /* Populate A CDF Skeleton file                                           */
  /**************************************************************************/

ByTe_1 ZVarLine (FILE *fi, ByTe_4 Type, ByTe_4 N, ByTe_1 *SIn, 
                                             ReaL_4 F, ByTe_4 Rets)
{
   extern struct UserDefs InFo;
 
   ByTe_4 Len;
   ByTe_1 FmT[150];

    fgets (FmT, 150, fi);                           /* Input Format         */
    if (FmT[0] == '*')                              /* Block end character  */
    {                                               /* BEG BLOCK END        */
       fprintf (InFo.fo, "\n");                     /* blank line           */
       return (0);                                  /* return a 0           */
    }                                               /* END BLOCK END        */
    else                                            /* maybe ignore line    */
    {                                               /* BEG IGNORE LINE      */
       if (N < 0)                                   /* no data this line    */
         return (1);                                /* out                  */
    }                                               /* END IGNORE LINE      */
   
    if (Rets > 0)                                   /* return is terminate  */
    {
       Len = strlen(FmT) - 1;
       FmT[Len++] = '.';
       FmT[Len++] = '\n';
       FmT[Len] = '\0';
    }

    switch (Type)                                   /* Input Type           */
    {                                               /* BEG LINE OUTPUT      */
       case 0:                                      /* START No Input       */
          fprintf (InFo.fo, FmT);                   /* direct copy          */
       break;                                       /* STOP No Input        */
       case 1:                                      /* START String Input   */
          fprintf (InFo.fo, FmT, SIn);              /* print string         */
       break;                                       /* STOP String Input    */
       case 2:                                      /* START Beg Epoch      */
          fprintf (InFo.fo, FmT, "1-Jan-1900 00:00:00.000");
       break;                                       /* STOP Beg Epoch       */
       case 3:                                      /* START End Epoch      */
          fprintf (InFo.fo, FmT, "1-Jan-2020 00:00:00.000");
       break;                                       /* STOP End Epoch       */
       case 4:                                      /* START Float Input    */
          fprintf (InFo.fo, FmT, F);                /* float input          */
       break;                                       /* STOP Float Input     */
    }                                               /* END LINE OUTPUT      */

    while (Rets-- > 0)                              /* Add Blank Lines      */
      fprintf (InFo.fo, "\n");                      /* blank line           */

    return (1);
}
