#include <string.h>
#include "OpSySInD.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

void ZVarFmt (ByTe_1 *VName, ByTe_1 *DType, ByTe_4 nEle, ByTe_4 nDim, 
              ByTe_4 *dSizes, ByTe_1 rVar, ByTe_1 *dVar)
{
    extern struct UserDefs InFo;

    register ByTe_4 *l1, NSpace;
    register ByTe_1 *c1, *c2, *cEnD;

    ByTe_4 Len;
    ByTe_1 Line[CDF_LINE_LEN];
    ByTe_1 Sp[80], Misc[80], Sizes[10], DimVar[10];

    Len = 18 - strlen (VName);
    cEnD = Sp + Len;
    for (c1 = Sp; c1 < cEnD;)
       *c1++ = ' ';
    *c1 = 0;

    sprintf (Line, "  \"%s\"%s%s", VName, Sp, DType);

    Len = 16 - strlen (DType);
    cEnD = Sp + Len;
    for (c1 = Sp; c1 < cEnD;)
       *c1++ = ' ';
    *c1 = 0;

    sprintf (Misc, "%s%d", Sp, nEle);
    strcat (Line, Misc);

    NSpace = (nEle > 9) ? 9 : (nEle > 99) ? 8 : (nEle > 999) ? 7 : 10;
    cEnD = Sp + NSpace;
    for (c1 = Sp; c1 < cEnD;)
       *c1++ = ' ';
    *c1 = 0;

    sprintf (Misc, "%s%d", Sp, nDim);
    strcat (Line, Misc);

    Sizes[0] = 0;
    DimVar[0] = 0;
    c1 = dVar;
    cEnD = dVar + nDim;
    for (l1 = dSizes; c1 < cEnD;)
    {
       sprintf (Misc, "%d ", *l1++);
       strcat (Sizes, Misc);
       sprintf (Misc, "%c ", *c1++);
       strcat (DimVar, Misc);
    }

    c2 = TrimString(Sizes);

    Len = strlen(c2);
    NSpace = 4 + (7 - Len)/2;
    cEnD = Sp + NSpace;
    for (c1 = Sp; c1 < cEnD;)
       *c1++ = ' ';
    *c1 = 0;

    sprintf (Misc, "%s%s", Sp, c2);
    strcat (Line, Misc);

    cEnD = Sp + 9 - Len/2;
    for (c1 = Sp; c1 < cEnD;)
       *c1++ = ' ';
    *c1 = 0;

    c1 = TrimString(DimVar);
    sprintf (Misc, "%s%c           %s\n", Sp, rVar, c1);
    strcat (Line, Misc);

    fprintf (InFo.fo, "%s\n", Line);
}
