#include <string.h>
#include <stdlib.h>
#include "OpSySInD.h"

#include "libbase_udf.h"
#include "user_defs.h"
#include "PidfStr.h"
#include "PidfAnsi.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

  /**************************************************************************/
  /* Populate A CDF Skeleton file                                           */
  /**************************************************************************/

#define EMPTY (ByTe_1 *)0

ByTe_1 UDFSkel ()
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern ByTe_1 *ScaRply[];
   extern ByTe_1 *FrmRply[];

   struct SrcInfo *S;
   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfSensor *Ps;
   struct PidfAnc *Pa;
   struct PidfMode *Pm;

   register ByTe_2 *s1, *sEnD; 

   FILE *fi;
   ReaL_4 V;
   ByTe_4 Var[10], N;
   ByTe_1 dV[2], MiscStr[80], Name[80], OMIN[15], VMIN[15], VMAX[15];
   ByTe_1 *c1;
   ByTe_1 *Cs;
   ByTe_1 SName[150];
   ByTe_1 *Fs = PathSep;

   Cs = (ByTe_1 *)Wa.CStore;

   sprintf(SName,"%s%sUDFToCDF%sZVARFLOAT.skt",getenv("UDFTOOL_HOME"), Fs, Fs);

   S = (struct SrcInfo *)InFo.Src;                  /* source here           */
   if (S->SType != 2)                               /* has scan data         */
      ScanSkel (0);                                 /* ZVar Scan Data        */

   V = OUTSIDE_MIN;
   sprintf (OMIN, "%.2e", V);
   V = VALID_MIN;
   sprintf (VMIN, "%.2e", V);
   V = VALID_MAX;
   sprintf (VMAX, "%.2e", V);

   dV[0] = 'T';

   s1 = (ByTe_2 *) InFo.SOrder;                     /* flags here            */
   sEnD = s1 + InFo.EmptySrc;                       /* end of flags here     */

   while (s1 < sEnD)                                /* do all sources        */
   {                                                /* BEG SOURCE LOOP       */
      N = *s1++;     
      S = (struct SrcInfo *)InFo.Src + N;           /* source here           */
      if ((fi = fopen (SName, "r")) == NULL)
         return (-1);

      ReadPidf (S->Key, InFo.PIDF);
      P = (struct Pidf *) InFo.PIDF;
      switch (S->DType)
      {
          case SeNsOr:
             Ps = (struct PidfSensor *)P->Sensors + S->GetPN;
             strcpy (Name, Ps->Name);
          break;
          case AnCiLlArY:
             Pa = (struct PidfAnc *)P->Ancil + S->GetPN;
             strcpy (Name, Pa->LDesc);
          break;
          case MoDe:
             Pm = (struct PidfMode *)P->Modes + S->GetPN;
             strcpy (Name, Pm->LDesc);
          break;
          case QuAl:
             strcpy (Name, P->Pq.LDesc);
         break;
      } 
      Pu = (struct PidfUnit *)P->Units + S->GetUN;
   
      switch (S->CDFDim)
      {
         case 0:
           Var[0] = 1;
         break;
         case 1:
            if (S->SType == 3)
               Var[0] = (S->UDFSrc < 2) ? S->DLen : S->TotMCols;
            else
               Var[0] = S->DLen;
         break;
         case 2:
            Var[1] = S->DLen;
            Var[0] = S->TotMCols;
            dV[1] = 'T';
         break;
      }

      ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                /* Header Line 1    */
      ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                /* Header Line 2    */
      ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                /* Underlines       */
      c1 = Cs + S->CdfName;
      ZVarFmt (c1, "CDF_FLOAT", 1, S->CDFDim, Var, 'T', dV); 
      ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                /* Attribute Line 1 */
      ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                /* Attribute Line 2 */
      ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                /* Underlines       */

      if (strlen(Name) > 30)
         Name[30] = 0;
      ZVarLine (fi, 1, 1, Name, 0.0, 0);                 /* FIELDNAM         */

      ZVarLine (fi, 1, 1, VMIN, 0.0, 0);                 /* VALID_MIN        */
      ZVarLine (fi, 1, 1, VMAX, 0.0, 0);                 /* VALID_MAX        */
      ZVarLine (fi, 4, 1, EMPTY, Pu->Min, 0);            /* SCALEMIN         */
      ZVarLine (fi, 4, 1, EMPTY, Pu->Max, 0);            /* SCALEMAX         */
      ZVarLine (fi, 1, 1, ScaRply[Pu->Sca - 1], 0.0, 0); /* SCAPETYP         */

      c1 = (strlen(Pu->LDesc) > 10) ? Pu->SDesc : Pu->LDesc;  
      ZVarLine (fi, 1, 1, c1, 0.0, 0);                   /* LABELAXIS        */

      strcpy (MiscStr, Pu->ULab);
      if (strlen (MiscStr) > 20)
          MiscStr[20] = 0;
      ZVarLine (fi, 1, 1, MiscStr, 0.0, 0);              /* UNITS           */

      ZVarLine (fi, 1, 1, "%13.6e", 0.0, 0);             /* FORMAT          */

      ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);              /* DELTA_PLUS_VAR   */
      ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);              /* DELTA_MINUS_VAR  */
      ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);              /* MONOTON          */
      ZVarLine (fi, 1, 1, " ", 0.0, 0);                 /* CATDESC          */
      ZVarLine (fi, 1, 1, OMIN, 0.0, 0);                /* FILLVAL          */
      ZVarLine (fi, 1, 1, " ", 0.0, 0);                 /* DICT_KEY         */
      ZVarLine (fi, 1, 1, "data", 0.0, 0);              /* VAR_TYPE         */
      ZVarLine (fi, 1, 1, "standard", 0.0, 0);          /* AVG_TYPE         */
      if (S->CDFDim == 0)
         ZVarLine (fi, 1, -1, "Histogram", 0.0, 0);     /* DISPLAY_TYPE     */
      else
         ZVarLine (fi, 1, -1, "Spectrogram", 0.0, 0);   /* DISPLAY_TYPE     */
      ZVarLine (fi, 1, 1, " ", 0.0, 0);                 /* Calib_input      */
      ZVarLine (fi, 1, 1, " ", 0.0, 0);                 /* Calib_software   */
      ZVarLine (fi, 1, 1, FrmRply[S->CDFDim], 0.0, 0);  /* FRAME            */
      ZVarLine (fi, 1, 1, "1", 0.0, 0);                 /* SC_id            */
      ZVarLine (fi, 1, 1, "10", 0.0, 0);                /* Sig_digits       */
      ZVarLine (fi, 1, 1, "na", 0.0, 0);                /* SI_conversion    */
      if (S->CDFDim > 0)
         ZVarLine (fi, 1, 1, "Center_Scan", 0.0, 0);    /* DEPEND_1         */
      else
         ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);           /* DEPEND_1         */
      ZVarLine (fi, 1, 1, "Epoch", 0.0, 1);             /* DEPEND_0         */
      fclose (fi);

      if (S->AddPh == 1)                                /* Add Pitch Info   */
      {
         PaSkel (N, 0);
         PaSkel (N, 1);
      }
      if (S->AddSp)
         ConsSkel (N, 0);
      if (S->AddQ)
         ConsSkel (N, 1);
      if (S->AddTh)
         ConsSkel (N, 2);
   }

   return (1);
}
