#include <string.h>
#include <stdlib.h>
#include "OpSySInD.h"

#include "libbase_udf.h"
#include "user_defs.h"
#include "PidfStr.h"
#include "PidfAnsi.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

#define EMPTY (ByTe_1 *)0

  /**************************************************************************/
  /* Populate A CDF Skeleton file                                           */
  /**************************************************************************/

ByTe_1 ScanSkel (ByTe_4 N)
{
   extern struct UserDefs InFo;
   extern ByTe_1 *ScaRply[];
   extern ByTe_1 *FrmRply[];

   struct SrcInfo *S; 

   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfSensor *Ps;
   struct PidfScan *Pc;

   FILE *fi;

   ReaL_4 V;
   ByTe_4 DiM, Var[10]; 
   ByTe_1 dV[2], MiscStr[80], *c1, OMIN[15], VMIN[15], VMAX[15];
   ByTe_1 SName[150];
   ByTe_1 *Fs = PathSep;

   V = OUTSIDE_MIN;
   sprintf (OMIN, "%.2e", V);
   V = VALID_MIN;
   sprintf (VMIN, "%.2e", V);
   V = VALID_MAX;
   sprintf (VMAX, "%.2e", V);

   sprintf(SName,"%s%sUDFToCDF%sZVARFLOAT.skt",getenv("UDFTOOL_HOME"), Fs, Fs);
   S = (struct SrcInfo *)InFo.Src + N; 

   ReadPidf (S->Key, InFo.PIDF);
   P = (struct Pidf *) InFo.PIDF;
   Ps = (struct PidfSensor *)P->Sensors + S->SenPN;
   Pc = (struct PidfScan *)P->Scans + Ps->ScanBlk;
   Pu = (struct PidfUnit *)P->Units + S->AltUN;

  /**************************************************************************/
  /* Open a the generic ZVAR EPOCH skeleton file                            */
  /**************************************************************************/

   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

   Var[0] = S->DLen;
   DiM = (S->DLen == 1) ? 0 : 1;
   dV[0] = 'T';

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt ("Center_Scan", "CDF_FLOAT", 1, DiM, Var, 'F', dV);  /* var def  */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, "Center Scan Values", 0.0, 0);   /* FIELDNAM         */
   ZVarLine (fi, 1, 1, VMIN, 0.0, 0);                   /* VALID_MIN         */
   ZVarLine (fi, 1, 1, VMAX, 0.0, 0);                   /* VALID_MAX         */
   ZVarLine (fi, 4, 1, EMPTY, Pu->Min, 0);              /* SCALEMIN         */
   ZVarLine (fi, 4, 1, EMPTY, Pu->Max, 0);              /* SCALEMAX         */
   ZVarLine (fi, 1, 1, ScaRply[Pu->Sca - 1], 0.0, 0);   /* SCALETYP         */

   c1 = (strlen(Pu->LDesc) > 10) ? Pu->SDesc : Pu->LDesc;  
   ZVarLine (fi, 1, 1, c1, 0.0, 0);                     /* LABELAXIS        */

   strcpy (MiscStr, Pu->ULab);
   if (strlen (MiscStr) > 20)
       MiscStr[20] = 0;
   ZVarLine (fi, 1, 1, MiscStr, 0.0, 0);                /* UNITS            */

   ZVarLine (fi, 1, 1, "%13.6e", 0.0, 0);               /* FORMAT           */
   ZVarLine (fi, 1, -1, "EMPTY", 0.0, 0);               /* DELTA_PLUS_VAR   */
   ZVarLine (fi, 1, -1, "EMPTY", 0.0, 0);               /* DELTA_MINUS_VAR  */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* MONOTON          */
   ZVarLine (fi, 1, 1, "Data Center Scan Values", 0.0, 0);  
   ZVarLine (fi, 1, 1, OMIN, 0.0, 0);                   /* FILLVAL          */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "data", 0.0, 0);                 /* VAR_TYPE         */
   ZVarLine (fi, 1, 1, "standard", 0.0, 0);             /* AVG_TYPE         */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_software   */
   ZVarLine (fi, 1, 1, FrmRply[DiM], 0.0, 0);           /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "na", 0.0, 1);                   /* SI_conversion    */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_0         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */

   fclose (fi);

  /**************************************************************************/
  /* Open a the generic ZVAR EPOCH skeleton file                            */
  /**************************************************************************/

   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt ("Upper_Bin_Edge", "CDF_FLOAT", 1, DiM, Var, 'F', dV); 
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, "Scan Bin Upper Edges", 0.0, 0);   /* FIELDNAM       */
   ZVarLine (fi, 1, 1, VMIN, 0.0, 0);                   /* VALID_MIN         */
   ZVarLine (fi, 1, 1, VMAX, 0.0, 0);                   /* VALID_MAX         */
   ZVarLine (fi, 4, 1, EMPTY, Pu->Min, 0);              /* SCALEMIN         */
   ZVarLine (fi, 4, 1, EMPTY, Pu->Max, 0);              /* SCALEMAX         */
   ZVarLine (fi, 1, 1, ScaRply[Pu->Sca - 1], 0.0, 0);   /* SCALETYP         */

   ZVarLine (fi, 1, 1, "Upper Bin Edges", 0.0, 0);      /* LABELAXIS        */

   strcpy (MiscStr, Pu->ULab);
   if (strlen (MiscStr) > 20)
       MiscStr[20] = 0;
   ZVarLine (fi, 1, 1, MiscStr, 0.0, 0);                /* UNITS            */

   ZVarLine (fi, 1, 1, "%13.6e", 0.0, 0);               /* FORMAT           */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_PLUS_VAR   */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_MINUS_VAR  */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* MONOTON          */
   ZVarLine (fi, 1, 1, "high Scan = Center_Scan + value", 0.0, 0);
   ZVarLine (fi, 1, 1, OMIN, 0.0, 0);                   /* FILLVAL          */
   ZVarLine (fi, 1,-1, EMPTY, 0.0, 0);                  /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "data", 0.0, 0);                 /* VAR_TYPE         */
   ZVarLine (fi, 1, 1, "standard", 0.0, 0);             /* AVG_TYPE         */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_software   */
   ZVarLine (fi, 1, 1, FrmRply[DiM], 0.0, 0);           /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "na", 0.0, 1);                   /* SI_conversion    */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_0         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */

   fclose (fi);

  /**************************************************************************/
  /* Open a the generic ZVAR EPOCH skeleton file                            */
  /**************************************************************************/

   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt ("Lower_Bin_Edge", "CDF_FLOAT", 1, DiM, Var, 'F', dV); 
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, "Scan Bin Lower Edges", 0.0, 0);   /* FIELDNAM       */
   ZVarLine (fi, 1, 1, VMIN, 0.0, 0);                   /* VALID_MIN         */
   ZVarLine (fi, 1, 1, VMAX, 0.0, 0);                   /* VALID_MAX         */
   ZVarLine (fi, 4, 1, EMPTY, Pu->Min, 0);              /* SCALEMIN         */
   ZVarLine (fi, 4, 1, EMPTY, Pu->Max, 0);              /* SCALEMAX         */
   ZVarLine (fi, 1, 1, ScaRply[Pu->Sca - 1], 0.0, 0);   /* SCALETYP         */

   ZVarLine (fi, 1, 1, "Lower Bin Edges", 0.0, 0);      /* LABELAXIS        */

   strcpy (MiscStr, Pu->ULab);
   if (strlen (MiscStr) > 20)
       MiscStr[20] = 0;
   ZVarLine (fi, 1, 1, MiscStr, 0.0, 0);                /* UNITS            */

   ZVarLine (fi, 1, 1, "%13.6e", 0.0, 0);               /* FORMAT           */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_PLUS_VAR   */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_MINUS_VAR  */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* MONOTON          */
   ZVarLine (fi, 1, 1, "high Scan = Center_Scan + value", 0.0, 0);  
   ZVarLine (fi, 1, 1, OMIN, 0.0, 0);                   /* FILLVAL          */
   ZVarLine (fi, 1,-1, EMPTY, 0.0, 0);                  /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "data", 0.0, 0);                 /* VAR_TYPE         */
   ZVarLine (fi, 1, 1, "standard", 0.0, 0);             /* AVG_TYPE         */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_software   */
   ZVarLine (fi, 1, 1, FrmRply[DiM], 0.0, 0);           /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "na", 0.0, 1);                   /* SI_conversion    */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_0         */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */

   fclose (fi);

   return (1);
}
