#include <math.h>
#include <stdlib.h>
#include <stdio.h>

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

void ScanEdges (void **Edges, ByTe_4 N)
{
   extern struct UserDefs InFo;

   struct SrcInfo *S;

   register ReaL_4 *f1, *f2, *f3, *f4, *fEnD;

   ReaL_4 V1, V2;
   ByTe_4 bytes;

   S = (struct SrcInfo *)InFo.Src; 

   bytes = (2 * S->DLen) * sizeof(ReaL_4);         /* this many bytes        */
   if ((*Edges = malloc(bytes)) == 0)              /* grab space             */
         ErrorRpt ("ScanEdges", 0, 2);             /* EGADS! an error        */

   f1 = (ReaL_4 *)S->Alt;                          /* 1st center value       */
   f2 = (ReaL_4 *)S->Alt + 1;                      /* next center value      */
   fEnD = f1 + S->DLen;                            /* end of center values   */
   f3 = (ReaL_4 *) *Edges;                         /* lower band deltas      */
   f4 = f3 + S->DLen;                              /* upper band deltas      */

   if (S->ScanSca == 0)                            /* if linear scaling      */
   {                                               /* BEG LINEAR SCALING     */ 
      *f3++ = *f1 - 0.5 * (*f2 - *f1);             /* first low edge         */
      *f4 = *f1 + 0.5 * (*f2++ - *f1++);           /* first high edge        */
      for ( ; f2 < fEnD; ++f1, ++f2)               /* loop over centers      */
      {                                            /* BEG LINEAR BAND LOOP   */
         V1 = 0.5 * (*f2 - *f1);                   /* half band              */
         *f3++ = *f4++;                            /* next contiguous edge   */
         *f4   = *f1 + V1;                         /* next contiguous edge   */

      }                                            /* END LINEAR BAND LOOP   */
      *f3++ = *f4++;                               /* next contiguous edge   */
      *f4 = *f1 + V1;                              /* last high delta        */
   }                                               /* END LINEAR SCALING     */ 
   else                                            /* must be log            */
   {                                               /* BEG LOG SCALING        */ 
      V1 = log (*f1++);                            /* log of first center    */
      V2 = log (*f2++);                            /* log of next center     */
      *f3++ = exp (V1 - 0.5 * (V2 - V1));          /* first low edge         */
      *f4 = exp (V1 + 0.5 * (V2 - V1));            /* first high edge        */
      for ( ; f2 < fEnD; ++f1, ++f2)               /* loop over centers      */
      {                                            /* BEG LINEAR BAND LOOP   */
         V1 = log (*f1);                           /* log of center          */
         V2 = log (*f2);                           /* log of next center     */
         *f3++ = *f4++;                            /* next low edge          */
         *f4 = exp (V1 + 0.5 * (V2 - V1));         /* next high edge         */
       }                                           /* END LINEAR BAND LOOP   */
       *f3++ = *f4++;                              /* last low edge          */
       *f4 = exp (V2 + 0.5 * (V2 - V1));           /* last high edge         */
   }                                               /* END LOG SCALING        */ 
}
