#include <string.h>
#include <stdlib.h>
#include "OpSySInD.h"

#include "libbase_udf.h"
#include "user_defs.h"
#include "PidfStr.h"
#include "PidfAnsi.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

#define EMPTY (ByTe_1 *)0

  /**************************************************************************/
  /* Populate A CDF Skeleton file                                           */
  /**************************************************************************/

ByTe_1 PaSkel (ByTe_4 N, ByTe_4 StSp)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern ByTe_1 *ScaRply[];
   extern ByTe_1 *FrmRply[];

   struct SrcInfo *S; 

   struct Pidf *P;
   struct PidfUnit *Pu;
   struct PidfSensor *Ps;
   struct PidfScan *Pc;

   FILE *fi;

   ReaL_4 V;
   ByTe_4 Var[10]; 
   ByTe_1 dV[2], MiscStr[80];
   ByTe_1 OMIN[15];
   ByTe_1 *Cs;
   ByTe_1 SName[150];
   ByTe_1 *Fs = PathSep;

   sprintf(SName,"%s%sUDFToCDF%sZVARFLOAT.skt",getenv("UDFTOOL_HOME"), Fs, Fs);
   S = (struct SrcInfo *)InFo.Src + N; 

   V = OUTSIDE_MIN;
   sprintf (OMIN, "%.2e", V);

   Cs = (ByTe_1 *)Wa.CStore;
   if (StSp == 0)
   {
      sprintf (MiscStr, "Beg_Phase_%s", Cs + S->CdfName);
      sprintf (MiscStr + 25, "Beg Phase Values");
   }
   else
   {
      sprintf (MiscStr, "End_Phase_%s", Cs + S->CdfName);
      sprintf (MiscStr + 25, "End Phase Values");
   }


   ReadPidf (S->Key, InFo.PIDF);
   P = (struct Pidf *) InFo.PIDF;
   Ps = (struct PidfSensor *)P->Sensors + S->SenPN;
   Pc = (struct PidfScan *)P->Scans + Ps->ScanBlk;
   Pu = (struct PidfUnit *)P->Units + S->AltUN;

  /**************************************************************************/
  /* Open a the generic ZVAR EPOCH skeleton file                            */
  /**************************************************************************/

   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

   dV[0] = 'T';
   switch (S->CDFDim)
   {
      case 0:
         Var[0] = 1;
      break;
      case 1:
         if (S->SType == 1 || (S->SType == 3 && S->PGet == 'R'))
            Var[0] = S->DLen;
         else
            Var[0] = S->TotMCols;
      break;
      case 2:
         Var[1] = S->DLen;
         Var[0] = S->TotMCols;
         dV[1] = 'T';
      break;
   }

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt (MiscStr, "CDF_FLOAT", 1, S->CDFDimP, Var, 'T', dV); 
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, MiscStr+25, 0.0, 0);             /* FIELDNAM         */
   ZVarLine (fi, 1, 1, "0.0", 0.0, 0);                  /* VALID_MIN        */
   ZVarLine (fi, 1, 1, "360.0", 0.0, 0);                /* VALID_MAX        */
   ZVarLine (fi, 4, 1, "0.0", 0.0, 0);                  /* SCALEMIN         */
   ZVarLine (fi, 4, 1, "360.0", 0.0, 0);                /* SCALEMAX         */
   ZVarLine (fi, 1, 1, ScaRply[0], 0.0, 0);             /* SCALETYP         */

   ZVarLine (fi, 1, 1, "Phase Ang", 0.0, 0);            /* LABELAXIS        */

   ZVarLine (fi, 1, 1, "Degrees", 0.0, 0);              /* UNITS            */

   ZVarLine (fi, 1, 1, "%13.6e", 0.0, 0);               /* FORMAT           */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_PLUS_VAR   */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_MINUS_VAR  */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* MONOTON          */
   ZVarLine (fi, 1, 1, MiscStr+25, 0.0, 0);  
   ZVarLine (fi, 1, 1, OMIN, 0.0, 0);                   /* FILLVAL          */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "data", 0.0, 0);                 /* VAR_TYPE         */
   ZVarLine (fi, 1, 1, "angle_degrees", 0.0, 0);        /* AVG_TYPE         */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_software   */
   ZVarLine (fi, 1, 1, FrmRply[S->CDFDimP], 0.0, 0);    /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "na", 0.0, 0);                   /* SI_conversion    */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */
   ZVarLine (fi, 1, 1, "Epoch", 0.0, 1);                /* DEPEND_0         */
      

   fclose (fi);

   return (1);
}
