#include <string.h>

#include "OpSySInD.h"
#include <time.h>
#include <stdlib.h>

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

ByTe_1 MoDayYr (long Yr, long Doy, long *Mo, long *Dy)
{
   register ByTe_2 I;
   ByTe_2 MDays[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
   ByTe_2 NDays, LastMo;
   ByTe_1 Leap;

   Leap = 0;
   if ((Yr % 4 == 0 && Yr % 100 != 0) || Yr % 400 == 0)
     Leap = 1;
   if (Leap)
     MDays[1] = 29;

   LastMo = 0;
   for (NDays = 0, I = 0; I < 12; ++I)
   {
      NDays += MDays[I];  
      if (Doy <= NDays)
      {
         *Mo = I + 1;
         *Dy = Doy - LastMo;
         return(1);
      }
      LastMo += MDays[I];
   }

   return (-1);
}
