#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

#include "UDFCDF_Str.h"
#include "UDFCDF_Ansi.h"

void GrowSrcs (ByTe_2 SrcB, ByTe_1 GrowBy)
{
   extern struct UserDefs InFo;
 
   struct SrcInfo *S;

   struct Pidf *P;
   struct PidfSensor *Ps, *PsEnD;
   struct PidfMode   *Pm;
   struct PidfAnc    *Pa;

   ByTe_4 Sz, B, NumInGrp;
   ByTe_2 Na, I, J, *s1;

   if (GrowBy == 0 || GrowBy == 3)
      return;

   Sz = sizeof (struct SrcInfo);

   S = (struct SrcInfo *)InFo.Src + SrcB;

   ReadPidf (S->Key, InFo.PIDF); 

   P = (struct Pidf *) InFo.PIDF;                   /* PIDF interface struct */ 
   Ps = (struct PidfSensor *) P->Sensors;           /* Sensor Info           */ 
   PsEnD = Ps + P->Ps.NSensors;                     /* Last Sensor           */ 

   if (GrowBy == 2)
   {
      NumInGrp = 0;                                 /* Sensors in Group      */
      Ps = (struct PidfSensor *) P->Sensors;        /* Sensor Info           */ 
      PsEnD = Ps + P->Ps.NSensors;                  /* Last Sensor           */ 
      for ( ; Ps < PsEnD; ++Ps)                     /* Sensor Group Loop     */
         if (S->Group == Ps->GroupNum)              /* Sensor in Group?      */
            ++NumInGrp;                             /* Count It              */
      
      InFo.NSrcs += NumInGrp - 1;                   /* New Num Srcs          */
      B = InFo.NSrcs * Sz;                          /* New Storage Size      */
      if ((InFo.Src = realloc (InFo.Src, B)) == 0)  /* Get new space         */ 
         exit(-1);                                  /* if error then - bye   */

      S = (struct SrcInfo *)InFo.Src + SrcB;
      Ps = (struct PidfSensor *) P->Sensors;        /* Sensor Info           */ 
      for (I = 0; I < P->Ps.NSensors; ++Ps, ++I)    /* Sensor Pickup Loop    */
      {                                             /* BEG GATHER SENSORS    */
         if ((S->Group == Ps->GroupNum) &&          /* Sensor in Group?      */
                          S->GetPN != Ps->PidfNum)  /* And Not Base sensor?  */
            DupSrc (SrcB, I, ChkUnits(S, I));
      }                                             /* END GATHER SENSORS    */
   }
   else
   {
      switch (S->DType)                             /* Data Type Switch      */
      {                                             /* BEG DATA TYPE SWITCH  */
         case 0:                                    /* START SENSOR          */
         case 1:                                    /* START SCAN            */

           InFo.NSrcs += P->Ps.NSensors - 1;        /* New Num Srcs          */
           B = InFo.NSrcs * Sz;                     /* New Storage Size      */
           if ((InFo.Src = realloc (InFo.Src, B)) == 0)  /* Get new space    */ 
              exit(-1);                             /* if error then - bye   */

           S = (struct SrcInfo *)InFo.Src + SrcB;   /* source pointer     */
           Ps = (struct PidfSensor *) P->Sensors;      /* Sensor Info        */ 
           for (I = 0; I < P->Ps.NSensors; ++Ps, ++I)  /* Sensor Pickup Loop */
           {                                           /* BEG GATHER SENSORS */
              if ( S->GetPN != Ps->PidfNum)            /* Not Base sensor?   */
                 DupSrc (SrcB, I, ChkUnits(S, I)); 
           }                                           /* END GATHER SENSORS */

         break;                                       /* STOP SENSOR/SCAN    */

         case 2:                                      /* START ANCILS        */
           Pa = (struct PidfAnc *) P->Ancil;          /* Anc Info            */ 
           Na = 0;                                    /* no ancillary info   */
           for (I = 0; I < P->Ps.NAncils; ++I, ++Pa)  /* Anc Test Loop       */
           {                                          /* BEG ANC COUNT LOOP  */
              if (Pa->Modify == 'Y')                  /* modifies sensor     */
              {                                       /* BEG SEARCH SENSORS  */
                 s1 = Pa->Sen;                        /* dependent sensors   */
                 for (J = 0; J < Pa->NSen; ++J)       /* sen search loop     */
                    if (*s1 < 0 || *s1 == S->SenPN)   /* got match?          */ 
                       ++Na;                          /* chalk up one        */
              }                                       /* END SEARCH SENSORS  */
              else                                    /* scan based          */
                 ++Na;                                /* always include      */
           }                                          /* END ANC COUNT LOOP  */

           InFo.NSrcs += Na - 1;                      /* New Num Srcs        */
           B = InFo.NSrcs * Sz;                       /* New Storage Size    */
           if ((InFo.Src = realloc (InFo.Src, B)) == 0)  /* Get new space    */ 
              exit(-1);                               /* if error then - bye */

           S = (struct SrcInfo *)InFo.Src + SrcB;     /* source pointer      */
           Pa = (struct PidfAnc *) P->Ancil;          /* Anc Info            */ 
           for (I = 0; I < P->Ps.NAncils; ++I, ++Pa)  /* Anc Test Loop       */
           {                                          /* BEG GATHER SENSORS  */
              if (S->GetPN != Pa->PidfNum)            /* Not Base mode?      */
                 DupSrc (SrcB, I, ChkUnits(S, I));
           }                                          /* END GATHER SENSORS  */

         break;                                       /* STOP ANCILS         */

         case 6:                                    /* START MODES           */
           InFo.NSrcs += P->Ps.NModes - 1;          /* New Num Srcs          */
           B = InFo.NSrcs * Sz;                     /* New Storage Size      */
           if ((InFo.Src = realloc (InFo.Src, B)) == 0)  /* Get new space    */ 
              exit(-1);                             /* if error then - bye   */

           S = (struct SrcInfo *)InFo.Src + SrcB;   /* source pointer     */
           Pm = (struct PidfMode *) P->Modes;          /* Sensor Info        */ 
           for (I = 0; I < P->Ps.NModes; ++Pm, ++I)    /* Sensor Pickup Loop */
           {                                           /* BEG GATHER SENSORS */
              if (S->GetPN != Pm->PidfNum)             /* Not Base mode?     */
                 DupSrc (SrcB, I, ChkUnits(S, I));
           }                                           /* END GATHER SENSORS */

         break;                                     /* STOP MODES            */
      }                                             /* END GATHER SENSORS    */
   }
}
