#include <string.h>

#include "OpSySInD.h"
#include <time.h>
#include <stdlib.h>

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

void EpochToCDF (ByTe_4 N, ByTe_4 rN, ByTe_1 *VName)
{
   extern struct UserDefs InFo;

   struct SrcInfo *S, *sEnD;

   ByTe_2 DaysInYr;
   ByTe_1 MiscStr[80];

   CDFstatus rV;
   double Epoch, Res;
   long Byr, Bdy, Mo, Day, Hr, Mn, Sc, Ms;
   long DYr, DDy;

   S = (struct SrcInfo *)InFo.Src; 
   sEnD = S + InFo.EmptySrc;                           /* last source number */
   for ( ; S < sEnD; ++S)                              /* loop over sources  */
   {                                                   /* BEG SOURCE LOOP    */
      if (S->Present == 1)                             /* valid source       */ 
         break;                                        /* exit loop          */
   }                                                   /* BEG SOURCE LOOP    */

   if (S == sEnD)
      return;

   Byr = S->Tb.Yr;
   Bdy = S->Tb.Dy;
   if (MoDayYr (Byr, Bdy, &Mo, &Day) < 0)
   {
      printf ("YIPES! - We got a bad time here!");
      exit (-1);
   }

   Hr = S->Tb.Ms / 3600000;
   Mn = S->Tb.Ms % 3600000 / 60000;
   Sc = ((S->Tb.Ms % 3600000) % 60000) / 1000;
   Ms = S->Tb.Ms % 1000;

   /***********************************************************************/
   /*  CDF routines                                                       */
   /***********************************************************************/

   Epoch = computeEPOCH (Byr, Mo, Day, Hr, Mn, Sc, Ms);
   if (Epoch < 0)
   {
      printf ("WOW! - CDF get error converting time to Epoch!");
      exit (-1);
   }

   rV = CDFlib (SELECT_, zVAR_NAME_, (char *) VName, zVAR_RECNUMBER_,
                   (long) rN, PUT_, zVAR_DATA_, &Epoch, NULL_);
   if (rV != CDF_OK)
   {
      printf ("ZAP! - CDF fails to write Epoch!");
      exit (-1);
   }

   /****************************************************************/
   /* Need ending time - just supplied beginning                   */
   /****************************************************************/

   Res = 0.0;
   sprintf (MiscStr, "%s_Start", VName);
   rV = CDFlib (SELECT_, zVAR_NAME_, MiscStr, zVAR_RECNUMBER_, 
                    (long) rN, PUT_, zVAR_DATA_, &Res, NULL_);
   if (rV != CDF_OK)
   {
      printf ("OUCH! - Got an error %d from CDFLib - what gives here?", rV);
      exit (-1);
   }

   /****************************************************************/
   /* Need time difference                                         */
   /****************************************************************/

   DYr = S->Te.Yr - S->Tb.Yr;
   DDy = S->Te.Dy - S->Tb.Dy;

   if (DDy != 0 || DYr != 0)
   {
      if ((S->Tb.Yr % 4 == 0 && S->Tb.Yr % 100 != 0) || S->Tb.Yr % 400 == 0)
         DaysInYr = 366;
      else
         DaysInYr = 365;

      Res = (DYr * DaysInYr  + DDy) * 86400000 + (S->Te.Ms - S->Tb.Ms); 
   }
   else
      Res = (S->Te.Ms - S->Tb.Ms); 

   while (Res < 0.0)
     Res += 86400000.0;

   sprintf (MiscStr, "%s_End", VName);
   rV = CDFlib (SELECT_, zVAR_NAME_, MiscStr, zVAR_RECNUMBER_,
                    (long) rN, PUT_, zVAR_DATA_, &Res, NULL_);
   if (rV != CDF_OK)
   {
      printf ("OUCH! - Got an error %d from CDFLib - what gives here?", rV);
      exit (-1);
   }
}

