#include <string.h>
#include <stdlib.h>
#include "OpSySInD.h"

#include "libbase_udf.h"
#include "user_defs.h"
#include "PidfStr.h"
#include "PidfAnsi.h"

#include "UDFCDF_Ansi.h"
#include "UDFCDF_Str.h"
#include "UDFCDF_Defs.h"

  /**************************************************************************/
  /* Populate A CDF Skeleton file                                           */
  /**************************************************************************/

#define EMPTY (ByTe_1 *)0

ByTe_1 ConsSkel (ByTe_4 N, ByTe_4 K)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;
   extern ByTe_1 *ScaRply[];
   extern ByTe_1 *FrmRply[];

   struct SrcInfo *S; 

   FILE *fi;

   ReaL_4 V;
   ByTe_4 Var[10]; 
   ByTe_1 dV[2], MiscStr[80];
   ByTe_1 OMIN[15];
   ByTe_1 *Cs;
   ByTe_1 *Fs = PathSep;
   ByTe_1 *Names[3] = {"Spin_Period", "DQual_", "Theta_"};
   ByTe_1 *FName[3] = {"Spin Period", "Data Quality", "Theta Angle"};
   ByTe_1 *ValMin[3] = {"-1.0e6", "0.0", "0.0"};
   ByTe_1 *ValMax[3] = {"1.0e6", "255.0", "180.0"};
   ByTe_1 *Units[3] = {"ms", "integer", "degrees"};
   ByTe_1 SName[150];

   sprintf(SName,"%s%sUDFToCDF%sZVARFLOAT.skt",getenv("UDFTOOL_HOME"), Fs, Fs);
   S = (struct SrcInfo *)InFo.Src + N; 

   V = OUTSIDE_MIN;
   if (K != 2)
      sprintf (OMIN, "%.2e", V);
   else
      sprintf (OMIN, "500.0");

   Cs = (ByTe_1 *)Wa.CStore;
   if (K > 0)
      sprintf (MiscStr, "%s%s", Names[K], Cs + S->CdfName);
   else
      sprintf (MiscStr, "%s", Names[K]);

  /**************************************************************************/
  /* Open a the generic ZVAR EPOCH skeleton file                            */
  /**************************************************************************/

   if ((fi = fopen (SName, "r")) == NULL)
      return (-1);

   dV[0] = 'T';
   Var[0] = 1;

  /**************************************************************************/
  /* CDF Preface Meta Data                                                  */
  /**************************************************************************/

   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 1    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Header Line 2    */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarFmt (MiscStr, "CDF_FLOAT", 1, 0, Var, 'T', dV); 
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 1 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Attribute Line 2 */
   ZVarLine (fi, 0, 1, EMPTY, 0.0, 0);                  /* Underlines       */
   ZVarLine (fi, 1, 1, FName[K], 0.0, 0);               /* FIELDNAM         */
   ZVarLine (fi, 1, 1, ValMin[K], 0.0, 0);              /* VALID_MIN        */
   ZVarLine (fi, 1, 1, ValMax[K], 0.0, 0);              /* VALID_MAX        */
   ZVarLine (fi, 4, 1, ValMin[K], 0.0, 0);              /* SCALEMIN         */
   ZVarLine (fi, 4, 1, ValMax[K], 0.0, 0);              /* SCALEMAX         */
   ZVarLine (fi, 1, 1, ScaRply[0], 0.0, 0);             /* SCALETYP         */
   ZVarLine (fi, 1, 1, FName[K], 0.0, 0);               /* LABELAXIS        */
   ZVarLine (fi, 1, 1, Units[K], 0.0, 0);               /* UNITS            */
   ZVarLine (fi, 1, 1, "%13.6e", 0.0, 0);               /* FORMAT           */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_PLUS_VAR   */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DELTA_MINUS_VAR  */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* MONOTON          */
   ZVarLine (fi, 1, 1, FName[K], 0.0, 0);  
   ZVarLine (fi, 1, 1, OMIN, 0.0, 0);                   /* FILLVAL          */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* DICT_KEY         */
   ZVarLine (fi, 1, 1, "data", 0.0, 0);                 /* VAR_TYPE         */
   ZVarLine (fi, 1, 1, "standard", 0.0, 0);             /* AVG_TYPE         */
   ZVarLine (fi, 1, 1, "Histogram", 0.0, 0);            /* DISPLAY_TYPE     */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_input      */
   ZVarLine (fi, 1, 1, " ", 0.0, 0);                    /* Calib_software   */
   ZVarLine (fi, 1, 1, FrmRply[0], 0.0, 0);             /* FRAME            */
   ZVarLine (fi, 1, 1, "1", 0.0, 0);                    /* SC_id            */
   ZVarLine (fi, 1, 1, "10", 0.0, 0);                   /* Sig_digits       */
   ZVarLine (fi, 1, 1, "na", 0.0, 0);                   /* SI_conversion    */
   ZVarLine (fi, 1, -1, EMPTY, 0.0, 0);                 /* DEPEND_1         */
   ZVarLine (fi, 1, 1, "Epoch", 0.0, 1);                /* DEPEND_0         */
      
   fclose (fi);

   return (1);
}
