#include <stdio.h>
#include <math.h>
#include "UDFCDF_Str.h"
#include "UDFCDF_Ansi.h"
#include "util_str.h"
#include "user_defs.h"
#include "ret_codes.h"
#include "idf_defs.h"
#include "libbase_udf.h"
#include "local_defs.h"
#include "ret_codes.h"

void CDFSetUp () 
{
   extern struct UserDefs InFo;
   extern struct CdfGenInfo CgI;

   struct SrcInfo *S, *SEnD;

   register ByTe_2 *s1, *sEnD; 

   ByTe_4 SrcN, I, Val;
   ByTe_2 Cntr[7];
   ByTe_2 R, N, CUse, EffSid, CTar;

   ByTe_1 *SrC[7] = { "SENSOR", "SCAN", "ANCILLARY", "SPINANGLE", 
                      "PITCHANGLE", "QUAL", "MODE" };
   ByTe_1 MiscStr[80];
   ByTe_1 OneSpin = 0;
   ByTe_1 Sca, NCon, Id;

   CgI.QualSrc = -1;                                   /* no qual source     */
   CgI.ScanSrc = -1;                                   /* no scan source     */
   sEnD = Cntr + 7; 
   for (s1 = Cntr; s1 < sEnD;)
       *s1++ = 1;

   S = (struct SrcInfo *)InFo.Src;
   SEnD = S + InFo.EmptySrc;


   s1 = (ByTe_2 *) InFo.SOrder;                        /* flags here         */
   sEnD = s1 + InFo.EmptySrc;                          /* end of flags here  */
   while (s1 < sEnD)                                   /* do all sources     */
   {                                                   /* BEG SOURCE LOOP    */
      SrcN = *s1++;                                    /* source number      */
      S = (struct SrcInfo *)InFo.Src + SrcN;           /* source here        */
      N = S->UDFSrc;                                   /* UDF source         */
      sprintf (MiscStr, "%s%d", SrC[N], Cntr[N]);      /* CDF Var Name       */
      S->CdfName = TransFer (MiscStr, 1, 0);           /* indx to name array */
      Cntr[N] += 1;                                    /* count it           */
      EffSid = S->SType;                               /* efffective smp id  */
      if (EffSid == 3 && S->TotMCols == 1)             /* 1 col matrix?      */
         EffSid = 1;                                   /* same as array      */

      if (S->AddSp == 1)                               /* wants a spin per   */
      {                                                /* BEG ONLY ONE       */
         if (OneSpin)                                  /* already requested  */
             S->AddSp = 0;                             /* turn it off        */
         else                                          /* first one          */
            OneSpin = 1;                               /* got one            */
      }                                                /* END ONLY ONE       */

      if (S->AddQ == 1)                                /* someone wants qual */
         CgI.QualSrc = SrcN;                           /* save src number    */

      switch (N)                                       /* meas type switch   */
      {                                                /* BEG SET CDF DIMEN  */
         case 0:                                       /* START SENSOR       */
            S->CDFDim = (EffSid == 2) ? 0 : (EffSid == 3) ? 2 : 1;
         break;                                        /* STOP SENSOR        */
         case 1:                                       /* START SCAN         */
            S->CDFDim = (S->DLen == 1) ? 0 : 1;        /* 1D if mult values  */
         break;                                        /* STOP SCAN          */
         case 2:                                       /* START ANCILLARY    */
            R = read_idf (S->Key, "", S->Ver, (ByTe_1 *)&CUse,   /* anc use  */ 
                          _CalUsE, 0, S->GetVN, 1);
            ErrorRpt ("GETVIDFINFO", R, 0);            /* error check        */
            R = read_idf (S->Key, "", S->Ver, (ByTe_1 *)&CTar,   /* anc plac */ 
                        _CalTargeT, 0, S->GetVN, 1);
            ErrorRpt ("GETVIDFINFO", R, 0);            /* error check        */
            if (CUse == 0)                             /* only one value     */
            {                                          /* BEG ONE VALUE      */
               if (CTar < 2)                           /* one for all        */
                  S->CDFDim = 0;                       /* scalar             */
               else                                    /* one per meas       */
                  S->CDFDim = (EffSid == 3) ? 1 : 0;   /* set dimension      */
            }                                          /* END ONE VALUE      */
            else                                      
               S->CDFDim = (EffSid == 2) ? 0 : (EffSid == 3) ? 2 : 1;
         break;                                        /* STOP ANCILLARY     */
         case 6:                                       /* START MODE         */
            S->CDFDim = 0;
         break;                                        /* STOP MODE          */
      }                                                /* END SET CDF DIMEN  */

      if (S->CDFDim > 0)                               /* multidim source    */
         CgI.ScanSrc = SrcN;                           /* must have scan     */

      if (S->AddPh == 1)                               /* need phase data    */
      {                                                /* BEG PHASE DATA     */
         if ((S->RowT == 1 && S->ColT == 1) || EffSid == 2)
            S->CDFDimP = 0;                            /* scalar phase data  */
         else                                          /* part sequential    */
         {                                             /* BEG SEQUENTIAL TST */
            if (S->RowT == 0 && S->ColT == 0)          /* seq/seq            */
               S->PGet = 'A';                          /* get them all       */
            else                                       /* only one seq       */
            {                                          /* BEG ONE SEQ        */
               S->CDFDimP = EffSid - 1;                /* reduce dimen by 1  */
               S->PGet = (S->RowT == 1) ? 'C' : 'R';   /* get per row or col */
            }                                          /* END ONE SEQ        */
         }                                             /* END SEQUENTIAL TST */
      }                                                /* END PHASE DATA     */

      /**********************************************************************/
      /*  If its there - get a theta value for this sensor, that is if it   */
      /*  is a sensor and not a mode                                        */
      /**********************************************************************/

      if (S->UDFSrc != 6)
      {
         R = read_idf (S->Key, "", S->Ver, &NCon, _NumConstS, 0, 0, -1);
         ErrorRpt ("GETVUDFTUFF", R, 0);

         I = 0;
         Id = -1;
         S->Theta = 500.0;
         while (I < NCon)
         {
            R = read_idf (S->Key, "", S->Ver, &Id, _ConstID, I, 0, -1);
            ErrorRpt ("GETVUDFTUFF", R, 0);
            if (Id == 1)
            {
               R = read_idf (S->Key, "", S->Ver, &Sca, _ConstScA, I, 
                                                             S->SenVN, 1);
               ErrorRpt ("GETVUDFTUFF", R, 0);
               R = read_idf (S->Key, "", S->Ver, (ByTe_1 *)&Val, _ConsT, 
                                                           I, S->SenVN, 1);
               ErrorRpt ("GETVUDFTUFF", R, 0);
               S->Theta = Val * ir_tento(Sca);
            }
            ++I;
         }
      }
   }                                                  /* END SOURCE LOOP    */
}
