#include <math.h>
#include <stdio.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_2 ValToColor (ReaL_4 V, ByTe_1 VSca, ReaL_4 *Conv)
{
    ReaL_4 Fc, Cv;
    ByTe_2 C;

    if (VSca == 1)                            /* log scaled                  */
       Cv = (V <= 0.0) ? -1.0e9 : log10 (V);  /* take log if V is OK         */
    else                                      /* linear                      */
       Cv = V;                                /* set to input                */

    Fc = Conv[1] + Conv[0] * Cv;              /* floating point color        */
    if (Fc > Conv[2])                         /* greater than max?           */
       C = Conv[2];                           /* set to max                  */
    else                                      /* otherwise                   */
       C = (Fc < Conv[3]) ? 0 : Fc;           /* less than min - set to 0    */

   return (C);
}
