#include <math.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void ScanEdges (ReaL_4 *C, ReaL_4 *W, ReaL_4 *Edges, ByTe_4 N, ByTe_1 Sca)
{
   register ReaL_4 *f1, *f2, *f3, *f4, *fEnD;

   f1 = C;
   f2 = E;

   ReaL_4 V1, V2;

   f1 = Cen;                                       /* 1st center value       */
   f2 = Cen + 1;                                   /* next center value      */
   fEnD = f1 + N;                                  /* end of center values   */
   f3 = Edges;                                     /* lower band edges       */

   if (Sca == 0)                                   /* if linear scaling      */
   {                                               /* BEG LINEAR SCALING     */ 
      *f3++ = *f1 - 0.5 * (*f2 - *f1);             /* first low edge         */
 
      for ( ; f2 < fEnD; ++f1, ++f2)               /* loop over centers      */
      {                                            /* BEG LINEAR BAND LOOP   */
         V1 = 0.5 * (*f2 - *f1);                   /* half band              */
         *f3++ = *f1 + V1;                         /* next contiguous edge   */
      }                                            /* END LINEAR BAND LOOP   */
 
      *f3 = *f1 + V1;                              /* last high edge         */
   }                                               /* END LINEAR SCALING     */ 
   else                                            /* must be log            */
   {                                               /* BEG LOG SCALING        */ 
      V1 = log (*f1);                              /* log of first center    */
      V2 = log (*f2);                              /* log of next center     */
      *f3++ = exp (V1 - 0.5 * (V2 - V1));          /* first low edge         */
 
      for ( ; f2 < fEnD; ++f1, ++f2)               /* loop over centers      */
      {                                            /* BEG LINEAR BAND LOOP   */
         V1 = log (*f1);                           /* log of center          */
         V2 = log (*f2);                           /* log of next center     */
         *f3++ = exp (V1 + 0.5 * (V2 - V1));       /* next edge              */
       }                                           /* END LINEAR BAND LOOP   */

      *f3 = exp (V2 + 0.5 * (V2 - V1));            /* last high edge         */
   }                                               /* END LOG SCALING        */ 
}
