#include <stdio.h>
#include <math.h>
#include "OpSySInD.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void RmFlow (ByTe_4 N, ByTe_4 SrcN, struct ToolInfo *Ti, ByTe_1 New, ByTe_1 Fmt)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;


   struct PlotDef *Pd;
   struct SrcInfo *S;

   register ReaL_4 *E, *A1, *A2, *T, *EnD;

   ReaL_4 dA, P, V, Vx, Vy, Vz;
   ReaL_4 Ct, R;
   ReaL_4 K, *T1, *T2, Theta;
   ByTe_1 *Cs, *Sp;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot info struct   */
   S = (struct SrcInfo *) Pd->Src + SrcN;              /* source structure   */

   if (Ti->Src == 1) {                                 /* UDF Source         */
      if (New)                                         /* new time base?     */
         VecData (&Ti->Vs, &Pd->Pb, &Pd->Pe, Ti->Avg); /* get vector         */
   }

   if (Fmt == 0) {                                    /* BEG MOD ENERGY      */
      if (S->AltUN > 0) {                             /* BEG FLOW REMOVAL    */
         Cs = (ByTe_1 *)Wa.CStore;                    /* 1 byte data area    */
         Sp = Cs + Pd->SecPos + 5;                    /* Theta data offset   */
         T1 = (ReaL_4 *)S->Sec + *Sp * S->DLen;       /* beg Theta angle     */
         T2 = T1 + S->DLen;                           /* end Theta angle     */
         E = (ReaL_4 *)S->Alt;                        /* pointer to scan     */
         A1 = (ReaL_4 *)S->Sec;                       /* ptr to beg azimuth  */
         A2 = A1 + S->DLen;                           /* ptr to end azimuth  */
         T = A2 + S->DLen;                            /* ptr to thetas       */
         EnD = E + S->DLen;                           /* end of scan         */
         K = 0.5 * S->Mass * 1.0e10 / 1.6e-12;        /* to eV (V km/s)      */
         R = M_PI / 180.0;                            /* degrees to rads     */
         for ( ; E < EnD; ++A2)                       /* scan loop           */
         {
            Theta = R * (*T1++ + *T2++)/2.0;          /* avg theta in Rad    */
            Ct = cos (Theta);                         /* cos theta           */
            V = sqrt (*E / K);
            Vx = V * cos (*A1 * R) * Ct - Ti->Avg[0];
            Vy = V * sin (*A1 * R) * Ct - Ti->Avg[1];
            Vz = V * sin(Theta) - Ti->Avg[2];
            P = atan2 (Vy, Vx) / R;
            if (P < 0.0)
               P += 360.0;
            dA = *A1 - P;
            *A1++ = P;
            *A2 -= dA;
            if (*A2 > 360)
               *A2 -= 360.0;
            else
               if (*A2 < 0.0)
                  *A2 += 360.0;
            *T++ = atan2 (Vz, sqrt (Vx * Vx + Vy * Vy)) / R;
            *E++ = K * (Vx * Vx + Vy * Vy + Vz * Vz);
         }
      }                                              /* END REMOVE FLOW     */
   }                                                 /* BEGIN FLOW REMOVAL  */
}
