#include <stdio.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void Normalize (ReaL_4 *D, ReaL_4 *N, ByTe_4 Len, ByTe_2 SLen, ReaL_4 Bad)
{
   register ReaL_4 *f1, *f2, *f3, *fEnD;

   f1 = D;                                         /* data is here           */
   f2 = N;                                         /* norm values are here   */
   fEnD = D + Len;                                 /* end of data is here    */

   if (SLen == 0) {                                /* BEG NORM COMPRESS      */
      f3 = D;                                      /* data is here again     */
      for ( ; f1 < fEnD; ++f1, ++f2)               /* BEG DATA LOOP          */
         *f3++ = (*f2 > 0.0) ? *f1 / *f2 : Bad;    /* normalize it           */
   } else {                                        /* BEG NORM NO COMPRESS   */
      for ( ; f1 < fEnD; ++f1, ++f2)               /* BEG DATA LOOP          */
         *f1 = (*f2 > 0.0) ? *f1 / *f2 : Bad;      /* normalize it           */
   }                                               /* END NORM NO COMPRESS   */
}
