#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void MenuTools (struct PlotDef *Pd, ByTe_4 PN, ByTe_2 TN, ByTe_4 ToolType)
{
   extern struct MeNuS Ms;

   struct PaGe      *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;
   struct ToolInfo  *Ti;
   struct CutDef *cD;

   ByTe_2  Mn; 
   ByTe_1  St[50];

   Ti = (struct ToolInfo *)Pd->Tools + TN;

 /**************************************************************************/
 /*                          PLOT TOOL MENU TRANSFER                       */
 /*                                                                        */
 /*  ID[00]  PLOT TYPE                     [0 - FLOW REMOVAL            ]  */
 /*                                        [1 - SHOW VECTOR             ]  */
 /*                                        [3 - GLOBE/OBJ               ]  */
 /*  ID[01]  VECTOR SOURCE                 [0 - USER DEFINED            ]  */
 /*                                        [1 - UDF SOURCE              ]  */
 /*                                        [2 - UNUSED SOURCE           ]  */
 /*  ID[02]  3 USER DEFINED VECTOR COMPS   [X] [Y] [X]                     */
 /*  ID[03]  VECTOR HEAD & TAIL SYMBOLS                                    */
 /*  ID[04]  VECTOR SYMBOL COLOR                                           */
 /*  ID[05]  VECTOR SYMBOL SIZE                                            */
 /*  ID[11]  VECTOR SOURCE                 [0 - USER DEFINED            ]  */
 /*                                        [1 - UDF SOURCE              ]  */
 /*                                        [2 - UNUSED SOURCE           ]  */
 /*  ID[12]  3 USER DEFINED VECTOR COMPS   [X] [Y] [X]                     */
 /*  ID[13]  VECTOR SOURCE                 [0 - USER DEFINED            ]  */
 /*                                        [1 - UDF SOURCE              ]  */
 /*                                        [2 - UNUSED SOURCE           ]  */
 /*  ID[14]  3 USER DEFINED VECTOR COMPS   [X] [Y] [X]                     */
 /**************************************************************************/

   Ti->Type = ToolType;
   Ti->Avg[0] = 0.0;
   Ti->Avg[1] = 0.0;
   Ti->Avg[2] = 0.0;
   Ti->MapFmt = 0;
   Ti->DisplayFmt = 0;
   Ti->Terminator = 0;
   Ti->LShell = 0;
   Ti->Color4 = 0;

   Pg = (struct PaGe *) Ms.page + PN;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ;

   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
            Ti->Type = Qs->OpReply;
         break;
         case 1:
            Ti->Src = Qs->OpReply;
            if (Ti->Src == 1) {
               sscanf (Qs->Wins, "%hd", &Mn);
               MenuVUDF (&Ti->Vs, Mn);
            }
         break;
         case 2:
            if (Qs->state == 1) {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply, "%f %f %f", 
                                 &Ti->Avg[0], &Ti->Avg[1], &Ti->Avg[2]); 
            } else
              if (Ti->Src == 0 ) Ti->Src = 2;
         break;
         case 3:
            if (Qs->state == 1) {
               BreaKOuT (Qs->CReply, St, 24, 1);
               Ti->Head = TransFer (St, 1, 0);
               Ti->Tail = TransFer (St + 24, 1, 0);
            }
         break;
         case 4:
            if (Qs->state == 1)
               Ti->Color1 = Qs->OpReply;
         break;
         case 5:
            if (Qs->state == 1)
               sscanf (Qs->CReply, "%hd", &Ti->Size); 
         break;
         case 6:
            if (Qs->state == 1)
               Ti->GlobeFmt = Qs->OpReply;
         break;
         case 7:
            if (Qs->state == 1)
               Ti->Color1 = Qs->OpReply;
         break;
         case 8:
            if (Qs->state == 1) {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply, "%f %f %f", 
                              &Ti->DeltaLat, &Ti->DeltaLong, &Ti->LatEnds); 
            }
         break;
         case 9:
            if (Qs->state == 1)
               Ti->MapFmt = Qs->OpReply;
         break;
         case 10:
            if (Qs->state == 1)
               Ti->Color2 = Qs->OpReply;
         break;
         case 11:
            Ti->Src1 = Qs->OpReply;
            if (Ti->Src1 == 1) {
               sscanf (Qs->Wins, "%hd", &Mn);
               MenuVUDF (&Ti->Vs1, Mn);
            }
         break;
         case 12:
            if (Qs->state == 1) {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply, "%f %f %f", 
                               &Ti->Avg1[0], &Ti->Avg1[1], &Ti->Avg1[2]); 
            } else
              if (Ti->Src1 == 0 ) Ti->Src1 = 2;
         break;
         case 13:
            Ti->Src2 = Qs->OpReply;
            if (Ti->Src2 == 1) {
               sscanf (Qs->Wins, "%hd", &Mn);
               MenuVUDF (&Ti->Vs2, Mn);
            }
         break;
         case 14:
            if (Qs->state == 1) {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply, "%f %f %f", 
                               &Ti->Avg2[0], &Ti->Avg2[1], &Ti->Avg2[2]); 
            } else
              if (Ti->Src2 == 0 ) Ti->Src2 = 2;
         break;
         case 15:
            if (Qs->state == 1)
               Ti->DisplayFmt = Qs->OpReply;
         break;
         case 16:
            if (Qs->state == 1)
               Ti->Terminator = Qs->OpReply;
         break;
         case 17:
            if (Qs->state == 1)
               Ti->Color3 = Qs->OpReply;
         break;
         case 18:
            if (Qs->state == 1) {
               Ti->LShell = Qs->OpReply;
               if (Qs->OpReply > 1) {
                  if ((Pd->LSCut = malloc (sizeof (struct CutDef))) == 0)
                      exit(-1); 
                  cD = (struct CutDef *)Pd->LSCut;
                  cD->CutPlace = Qs->OpReply - 2;
                  cD->CutSpace = 1.0;
                  cD->CutPlot = 1;
               }
            }
         break;
         case 19:
            if (Qs->state == 1)
               Ti->Color4 = Qs->OpReply;
         break;
         case 20:
            if (Qs->state == 1) {
               BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
               sscanf (Qs->CReply, "%f %f %f", 
                               &Ti->LRng[0], &Ti->LRng[1], &Ti->LRng[2]); 
            }
         break;
      }
   }
}
