#include <stdio.h>
#include <string.h>
#include <math.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "UDFpltStr.h"
#include "UDFpltDefs.h"
#include "UDFpltAnsi.h"

/*****************************************************************************/
/*  This program puts up all src labels associated with a given line plot    */
/*  need to be put up immediately after the plot is put up on the screen     */
/*  least they be lost.                                                      */
/*****************************************************************************/

void GenLabs (ByTe_4 PNuM, ByTe_2 sN, ByTe_4 pN, ByTe_4 RpN, ByTe_2 LSrc,
              ByTe_2 SubL, ByTe_2 Lev, ByTe_2 Coff, ByTe_1 *CLab)
{
   extern struct UserDefs InFo;
   extern struct config parm;

   struct PlotDef *Pd;
   struct SrcInfo *S;

   ReaL_4 X, Y, Sz[2], R, XL, XR, Sn, Lv, dX, dY; 
   ByTe_4 dYs, Rem, dYp, Pn, MaxL, TnP, LnP, N, GrP;
   ByTe_2 *s1, C, RoW, CoL, Lc;
   ByTe_1 L[100], Wn; 
   ByTe_1 J, Right, OK;

   N = PNuM % InFo.NPDefs; 
   GrP = PNuM / InFo.NPDefs; 

   Pd = (struct PlotDef *)InFo.PlotDefs + N;           /* plot info struct   */
   S = (struct SrcInfo *)Pd->Src + sN;                 /* ptr to src in plot */
   
   Lc = Pd->Cols - 1;
   if (Pd->TimeDir == 1) {                             /* BEG SEQUENTIAL     */
      RoW = pN / Pd->Cols;                             /* current row number */
      CoL = pN % Pd->Cols;                             /* current col number */
   } else {                                            /* BEG INCREMENT      */
      RoW = pN % Pd->Rows;                             /* current row number */
      CoL = pN / Pd->Rows;                             /* current col number */
   }                                                   /* END INCREMENT      */

   switch (Pd->Li[LSrc].Occur)                         /* label occurances   */
   {                                                   /* BEG OCCURRANCES    */
      case 0:                                          /* START ONCE         */
        if (GrP == 0)
        {
           if (Pd->Li[LSrc].LocA == 6)
              OK = (((CoL % Pd->Cols) == Lc) && (RoW == 0)) ? 1 : 0; 
           else
           {
              if (Pd->Li[LSrc].LocA == 4)
                  OK = (((CoL % Pd->Cols) ==0)) && (RoW == 0) ? 1 : 0;
              else
                 OK = (pN == 0) ? 1 : 0;
           }
        } else
           OK = 0;
      break;                                           /* STOP ONCE          */
      case 1:                                          /* START ONCE/PLOT    */
        OK = 1;                                        /* always proceed     */
      break;                                           /* STOP ONCE/PLOT     */
      case 2:                                          /* START ONCE / COL   */
        OK = ((CoL < Pd->Cols) && (RoW == 0)) ? 1 : 0; /* OK if top row      */
      break;                                           /* STOP ONCE / COL    */
      case 3:                                          /* START ONCE / ROW   */
        if (Pd->Li[LSrc].LocA == 6)                    /* right side         */
          OK = ((CoL % Pd->Cols) == Lc) ? 1 : 0; /* OK right col */
        else                                                 /* all else     */
          OK = ((CoL % Pd->Cols) ==0) ? 1 : 0;         /* OK left col        */
      break;                                           /* STOP ONCE / ROW    */
      case 4:                                          /* START ONCE/GRP     */
        if (Pd->Li[LSrc].LocA == 6)
           OK = (((CoL % Pd->Cols) == Lc) && (RoW == 0)) ? 1 : 0; 
        else
        {
           if (Pd->Li[LSrc].LocA == 4)
               OK = (((CoL % Pd->Cols) ==0)) && (RoW == 0) ? 1 : 0;
           else
              OK = (pN == 0) ? 1 : 0;
        }
      break;                                           /* STOP ONCE/GRP      */
   }                                                   /* END OCCURRANCES    */

   if (Pd->Li[LSrc].Fmt < 0 || !OK)                    /* no lab             */
      return;                                          /* nothing to do      */

   Right = Lev % 2;                                    /* left or right lab  */
   Wn = Pd->Wn;                                        /* plot number        */
   s1 = &parm.white;                                   /* base color         */
   if (Pd->Li[LSrc].LocB == 0)                         /* spread             */
      Lev /= 2;                                        /* label level        */

   clip (Wn, 0);                                       /* turn off clipping  */
   chr_size (Pd->Li[LSrc].Size);                       /* set label size     */
   get_chsz (Sz);                                      /* character size     */

   C = (Coff >= 100) ? *(s1 + (Coff % 100)) : *(s1 + Pd->Li[LSrc].Color);
   if (parm.ostyle == 0)                               /* landscape          */
   {                                                   /* BEG LANDSCAPE SETS */
      XL = 0.0;                                        /* Left X Coordinate  */
      XR = 1.0;                                        /* Right X Coordinate */
      Sn = 1.0;                                        /* no reversal        */
   }                                                   /* END LANDSCAPE SETS */
   else                                                /* portrait           */
   {                                                   /* BEG PORTRAIT SETS  */
      XL = 1.0;                                        /* Left X Coordinate  */
      XR = 0.0;                                        /* Right X Coordinate */
      Sn = -1.0;                                       /* reversal           */
   }                                                   /* END PORTRAIT SETS  */

   if (Pd->Li[LSrc].LocA < 4 || Pd->Li[LSrc].LocB != 2) /* Label Along X-Axis */
   {                                                   /* BEG X SETS         */
      R = 0.0;                                         /* non-rotated labels */
      Y = (Pd->Li[LSrc].LocA == 0) ? 0.0 : 1.0;        /* L0 Y begin point   */
      Y += Pd->Li[LSrc].YOff * Sz[1];                  /* corrected L0 Y pos */
      Lv = 1.25 * Lev * Sz[1]; 
      Y = (Pd->Li[LSrc].YOff > 0.0) ? Y + Lv : Y - Lv; /* level displacement */

      dX = Sn * Pd->Li[LSrc].XOff * Sz[0];             /* Xoffset            */
      switch (Pd->Li[LSrc].LocB)                       /* lab pos switch     */
      {                                                /* BEG LAB POS SWITCH */
         case 0:                                       /* START SPREAD       */
           if (!Right)                                 /* left or right lab  */
           {                                           /* BEG LEFT SETS      */
              X = XL + dX;                             /* pos at left axis   */
              J = -1;                                  /* and left justify   */
           }                                           /* END LEFT SETS      */
           else                                        /* on the right       */
           {                                           /* BEG RIGHT SETS     */
              X = XR - dX;                             /* pos at right axis  */
              J = 1;                                   /* and right justify  */
           }                                           /* END RIGHT SETS     */
         break;                                        /* STOP SPREAD        */
         case 1:                                       /* START MINIMUM      */
           X = XL + dX;                                /* pos at left axis   */
           if (Pd->Li[LSrc].LocA > 2)                  /* Y axis             */
              J = (Pd->Li[LSrc].LocA == 4) ? 1 : -1;   /* justify            */
           else                                        /* X axis             */
              J = -1;                                  /* and justify        */
         break;                                        /* STOP MINIMUM       */
         case 2:                                       /* START CENTER       */
           X = 0.5 + dX;                               /* pos at center axis */
           J = 0;                                      /* and center justify */
         break;                                        /* STOP CENTER        */
         case 3:                                       /* START MAXIMUM      */
           X = XR + dX;                                /* pos at right axis  */
           if (Pd->Li[LSrc].LocA > 2)                  /* Y axis             */
              J = (Pd->Li[LSrc].LocA == 4) ? 1 : -1;   /* justify            */
           else                                        /* X axis             */
              J = 1;                                   /* and justify        */
         break;                                        /* STOP MAXIMUM       */
      }                                                /* END LAB POS SWITCH */
   }                                                   /* END X SETS         */
   else                                                /* label along Y      */
   {                                                   /* BEG Y SETS         */
      if (Pd->Li[LSrc].LocB == 2)                      /* if centered lab    */
         R = (Pd->Li[LSrc].LocA == 4) ? 90.0 : -90.0;  /* L0 label rotation  */
      else                                             /* not centered       */
         R = 0.0;                                      /* horizontal label   */
      X = (Pd->Li[LSrc].LocA == 4) ? XL : XR;          /* L0 X begin point   */
      X += Sn * Pd->Li[LSrc].XOff * Sz[0];             /* corrected L0 X pos */
      X += 2.0 * Sn * Lev * Sz[0];                     /* corrected L0 X pos */

      dY = Pd->Li[LSrc].YOff * Sz[1];                  /* YOffset            */
      switch (Pd->Li[LSrc].LocB)                       /* lab pos switch     */
      {                                                /* BEG LAB POS SWITCH */
         case 0:                                       /* START SPREAD       */
           Y = 0.5 + dY;                               /* pos at left axis   */
           J = 0;                                      /* and left justify   */
         break;                                        /* STOP SPREAD        */
         case 1:                                       /* START MINIMUM      */
           Y = dY;                                     /* pos at left axis   */
           J = -1;                                     /* and left justify   */
         break;                                        /* STOP MINIMUM       */
         case 2:                                       /* START CENTER       */
           if (LSrc == 1 && S->LpType == 10)           /* spectroscalar      */
           {                                           /* BEG SPECTROSCALAR  */
              R = 0;                                   /* lab is horizontal  */
              J = 1;                                   /* right justify      */
              Pn = RpN % Pd->Stack;                    /* RpN in plot        */
              LnP = Pd->nGL - (Pd->nGL / Pd->Stack) * Pd->Stack; 
              TnP = Pd->nGL - RpN;                     /* plots left         */
              MaxL = (TnP > LnP) ? Pd->Stack : LnP;    /* plots in panel     */
              dYp = Pd->P.dY - 1 - Pd->Gap * (MaxL - 1);  /* pixels along Y  */
              dYs = dYp / MaxL;                        /* pixels per strip   */
              Rem = dYp % MaxL;                        /* left over pixels   */
              Y = Pd->Yr.Min + Pn * (dYs + Pd->Gap) + 1;   /* begin Y        */
              if (Pn > Rem)                            /* used extra pixels  */
                 Y += Rem + (dYs - 1)/2.0;             /* center Y           */
              else                                     /* still some to use  */
                 Y += Pn + (dYs - 1)/2.0;              /* center Y           */
           }                                           /* BEG SPECTROSCALAR  */
           else                                        /* simple plot        */
           {                                           /* BEG SIMPLE PLOT    */
              Y = 0.5 + dY;                            /* pos at center axis */
              J = 0;                                   /* and center justify */
           }                                           /* BEG SIMPLE PLOT    */
         break;                                        /* STOP CENTER        */
         case 3:                                       /* START MAXIMUM      */
           Y = 1.0 + dY;                               /* pos at right axis  */
           J = -1;                                     /* and right justify  */
         break;                                        /* STOP MAXIMUM       */
      }                                                /* END LAB POS SWITCH */
   }                                                   /* END Y SETS         */

   if (strlen(CLab) == 0)
      LabelMkr (N, sN, pN, RpN, LSrc, SubL, L);        /* form source label  */
   else
      strcpy (L, CLab);

   if ((Pd->PType == 0 || Pd->PType == 5)
                        && (Pd->AData[1] == 1 || Pd->AData[0] == 1) 
                        && S->LpType != 10 && LSrc == 1) 
   {
      if ((S->PCol + Coff) < 0) 
          Coff = 10;
      C = *(s1 + S->PCol + Coff);                      /* color by plot      */
   }

   chr_dspl (Wn, X, Y, 0., R, 0., 0., 0, J, L, -1, C);
}
