#include <stdio.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void FillGaps (ByTe_4 PN, ByTe_4 pN, ByTe_1 Dir) 
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct Binning *Bn;

   register ReaL_4 *Px, *Nr;
   register ByTe_4 I, J, L = 0;

   ReaL_4  Y1, Y2, X1, X2, Xt, A, B, X, Cen;
   ByTe_4  LastG, Gap, Up, P;
   ByTe_4  Inc, PEnd, End, Next;
   ByTe_1  Fmt;

   Pd = (struct PlotDef *)InFo.PlotDefs + PN;          /* plot def struct    */

   Px = (ReaL_4 *)Wa.WorkSpace + 2 * pN * Pd->PlotLen; /* base plot position */
   Nr = Px + Pd->PlotLen;                              /* base norm position */

   if (Dir == 'X')                                     /* fill along X       */
   {                                                   /* BEG X SETS         */
      Fmt = Pd->Bx.Empty;                              /* fill format        */
      Inc = Pd->Byl.N;                                 /* to next data value */
      PEnd = Pd->Byl.N;                                /* bins along Y       */
      End = Pd->PlotLen;                               /* end of row         */
      Bn = &Pd->Bx;                                    /* X Binning info     */
      Next = 1;                                        /* beg of next row    */
   }                                                   /* END X SETS         */
   else                                                /* fill along Y       */
   {                                                   /* BEG Y SETS         */
      Fmt = Pd->Byl.Empty;                             /* fill format        */
      Inc = 1;                                         /* to next data value */
      PEnd = Pd->Bx.N;                                 /* bins along X       */
      End = Pd->Byl.N;                                 /* end of col         */
      Bn = &Pd->Byl;                                   /* Y Binning info     */
      Next = Pd->Byl.N;                                /* beg of next col    */
   }                                                   /* END Y SETS         */

   if (Fmt == 0)                                       /* leave any gaps     */ 
      return;                                          /* OK                 */


   switch (Fmt)                                        /* fill switch        */
   {                                                   /* BEGIN FILL SWITCH  */
      case 1:                                          /* START CONST FILL   */
      case 2:                                          /* START CONST FILL   */
         for (; L < PEnd; ++L, Px += Next, Nr += Next) /* row/col loop       */
         {                                             /* BEG ROW/COL FILL   */ 
            I = 0;                                     /* index to beg scan  */
            while (I < End)                            /* first good loop    */
            {                                          /* BEG TO FIRST       */
              if (*(Nr + I) < 0.0)                     /* no data            */
                 I += Inc;                             /* check next data    */
              else                                     /* got one            */
                 break;                                /* quit               */
            }                                          /* END TO FIRST       */

            if (I >= End)                              /* line exhausted     */
               continue;                               /* try next           */

            LastG = I;                                 /* last good data pos */ 
            I += Inc;                                  /* next data pos      */
            for ( ; I < End; I += Inc)                 /* loop over line     */
            {                                          /* BEG FINISH LINE    */
               if (*(Nr + I) < 0.0)                    /* empty slot         */
               {                                       /* BEG FILL GAPS      */
                  J = I;                               /* don't lose I       */
                  Gap = 0;                             /* no empty slots     */
                  while (J < End)                      /* first good loop    */
                  {                                    /* BEG GAP COUNT      */
                    if (*(Nr + J) < 0.0)               /* no data            */
                    {                                  /* BEG NO DATA        */
                       J += Inc;                       /* check next data    */
                       ++Gap;                          /* count gap          */
                    }                                  /* END NO DATA        */
                    else                               /* got one            */
                       break;                          /* quit               */
                  }                                    /* END GAP COUNT      */

                  if (J < End)                         /* good upper val?    */
                  {                                    /* BEG FILLING        */
                     Up = (Fmt == 1) ? I + (Gap / 2 + (Gap % 2)) * Inc : J;
                     for ( ; I < Up; I += Inc)         /* lower half loop    */
                     {                                 /* BEG UP LOOP        */
                        *(Px + I) = *(Px + LastG);     /* fill gap           */
                        *(Nr + I) = 0.0;               /* data here          */
                     }                                 /* END UP LOOP        */
                     for (  ; I < J; I += Inc)         /* top half loop      */
                     {                                 /* BEG DOWN LOOP      */
                        *(Px + I) = *(Px + J);         /* count gaps         */
                        *(Nr + I) = 0.0;               /* data here          */
                     }                                 /* END DOWN LOOP      */
                     LastG = I;                        /* set last good      */
                  }                                    /* END FILLING        */
                  else                                 /* past the end       */
                     I = End;                          /* terminate loop     */
               }                                       /* END FILL EMPTYS    */
               else                                    /* valid data         */
                  LastG = I;                           /* last good slot     */
            }                                          /* END FINISH LINE    */
         }                                             /* END ROW/COL FILL   */ 
      break;                                           /* STOP CONST FILL    */
      case 3:                                          /* START LINER FILL   */
         for (; L < PEnd; ++L, Px += Next, Nr += Next) /* row/col loop       */
         {                                             /* BEG ROW/COL FILL   */ 
            I = 0;                                     /* index to beg scan  */
            while (I < End)                            /* first good loop    */
            {                                          /* BEG TO FIRST       */
              if (*(Nr + I) < 0.0)                     /* no data            */
                 I += Inc;                             /* check next data    */
              else                                     /* got one            */
                 break;                                /* quit               */
            }                                          /* END TO FIRST       */

            if (I >= End)                              /* line exhausted     */
               continue;                               /* try next           */

            P = I / Inc;                               /* bin number         */
            GetBinStats (Bn, P, &X1, &Xt, &Cen, 1);    /* bin value at good  */
            Y1 = *(Px + I);                            /* pix value at good  */

            LastG = I;                                 /* last good data pos */ 
            I += Inc;                                  /* next data pos      */
            for ( ; I < End; I += Inc)                 /* loop over line     */
            {                                          /* BEG FINISH LINE    */
               if (*(Nr + I) < 0.0)                    /* empty slot         */
               {                                       /* BEG FILL GAPS      */
                  J = I;                               /* don't lose I       */
                  Gap = 0;                             /* no empty slots     */
                  while (J < End)                      /* first good loop    */
                  {                                    /* BEG GAP COUNT      */
                    if (*(Nr + J) < 0.0)               /* no data            */
                    {                                  /* BEG NO DATA        */
                       J += Inc;                       /* check next data    */
                       ++Gap;                          /* count gap          */
                    }                                  /* END NO DATA        */
                    else                               /* got one            */
                       break;                          /* quit               */
                  }                                    /* END GAP COUNT      */

                  if (J < End)                         /* good upper val?    */
                  {                                    /* BEG FILLING        */
                     P = J / Inc;                      /* bin number         */
                     GetBinStats (Bn, P, &X2, &Xt, &Cen, 1); /* bin value    */
                     Y2 = *(Px + J);                   /* pix value          */
                     A = (Y2 - Y1)/(X2 - X1);          /* slope              */
                     B = Y1 - A * X1;                  /* intercept          */
                     for ( ; I < J; I += Inc)          /* fill gap loop      */
                     {                                 /* BEG LINEAR FILL    */
                        P = I / Inc;                   /* bin number         */
                        GetBinStats (Bn, P, &X, &Xt, &Cen, 1); /* bin value  */
                        *(Px + I) = A * X + B;           /* fit value        */
                        *(Nr + I) = 0.0;                 /* data here        */
                     }                                 /* END LINEAR FILL    */
                     LastG = I;                        /* last good slot     */
                     X1 = X2;                          /* last bin value     */
                     Y1 = Y2;                          /* last intensity     */
                  }                                    /* END FILLING        */
                  else                                 /* past the end       */
                     I = End;                          /* terminate loop     */
               }                                       /* END FILL EMPTYS    */
               else                                    /* valid data         */
               {                                       /* BEG SAVE LAST      */
                  LastG = I;                           /* last good slot     */
                  P = I / Inc;                         /* bin number         */
                  GetBinStats (Bn, P, &X1, &Xt, &Cen, 1);    /* bin value    */
                  Y1 = *(Px + I);                      /* pix value          */
               }                                       /* END SAVE LAST      */
            }                                          /* END FINISH LINE    */
         }                                             /* END ROW/COL FILL   */ 
      break;                                           /* STOP LINEAR FILL   */
   }                                                   /* END FILL SWITCH    */
}
