#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

void DupSrc (struct PlotDef *Pd, ByTe_2 SrcB, ByTe_2 N, ByTe_2 J, ByTe_2 UnitN)
{
   extern struct UserDefs InFo;
   extern ByTe_1 *ScatSym[];
   extern struct WorkArea Wa;

   struct SrcInfo *S, *Sn, *Sp;
   struct Pidf *P;
   struct PidfSensor *Ps;
   struct PidfMode *Pm;

   ByTe_2 I;
   ByTe_1 *Wc, *c1;

   if (UnitN < 0)
      return;

   S = (struct SrcInfo *)Pd->Src + SrcB;
   Sn = (struct SrcInfo *)Pd->Src + Pd->EmptySrc++;
   Sp = Sn - 1;
   P = (struct Pidf *)InFo.PIDF;

   if (S->ScatSym != 0)
   {
      Wc = (ByTe_1 *)Wa.CStore;
      c1 = Wc + S->ScatSym;
      for (I = 0; I < 10; ++I)
      {
         if (strcmp (ScatSym[I], c1) == 0)
            break;
      }
      if (I == 10)
         I = 0;
   }
   else
      I = -J;

   switch (S->DType)                               /* switch on data type    */
   {                                               /* BEG DATA TYPE SWITCH   */
      case 0:                                      /* START SENSOR           */
      case 1:                                      /* START SCAN             */
        Ps = (struct PidfSensor *)P->Sensors + N;  /* Sensor Info            */ 
        Sn->GetPN = Ps->PidfNum;                   /* Xfer Pidf Get Num      */
        Sn->SenPN = Ps->PidfNum;                   /* Xfer Pidf Sen Num      */
        Sn->GetUN = UnitN;                         /* Xfer Unit Number       */
        Sn->AltUN = S->AltUN;                      /* Xfer Alt Unit Num      */
        Sn->SAltUN = S->SAltUN;                    /* Xfer 2nd Alt Unit Num  */
        Sn->SAltPN = S->SAltPN;                    /* Xfer Alt Pidf Num      */
        Sn->SenCN = S->SenCN;                      /* Xfer Alt Pidf Num      */
        Sn->AltSB = S->AltSB;                      /* Xfer Alt Pidf Num      */
        Sn->PCol = S->PCol - 10;                   /* keep color             */
        Sn->ECol = S->ECol - 10;                   /* keep color             */
        Sn->LpType = S->LpType;                    /* Xfer plot format       */
        Sn->Col.Fmt = S->Col.Fmt;                  /* Xfer collapse flag     */
        Sn->Col.NewHdr = S->Col.NewHdr;            /* Xfer new header flag   */
        Sn->Col.Start = S->Col.Start;              /* Xfer begin collapse    */
        Sn->Col.Stop = S->Col.Stop;                /* Xfer end collapse      */
        Sn->Col.Sca = S->Col.Sca;                  /* Xfer collapse bin sca  */
        Sn->Col.Pos = S->Col.Pos;                  /* Xfer col beg/end pos   */
        Sn->Col.N = S->Col.N;                      /* Xfer number of bins    */
        Sn->SymSize = S->SymSize;                  /* symbol size            */
        Sn->ScatSym = (I + J) % 10;                /* scatter symbol         */
      break;                                       /* STOP SENSOR OR SCAN    */
      case 2:                                      /* START SCAN             */
        Ps = (struct PidfSensor *)P->Sensors + N;  /* Sensor Info            */ 
        Sn->GetPN = Ps->PidfNum;                   /* Xfer Pidf Get Num      */
        Sn->SenPN = Ps->PidfNum;                   /* Xfer Pidf Sen Num      */
        Sn->GetUN = S->GetUN;                      /* Xfer Unit Number       */
        Sn->AltUN = UnitN;                         /* Xfer Alt Unit Num      */
        Sn->AltSB = S->AltSB;                      /* Xfer Alt Pidf Num      */
        Sn->Col.Fmt = S->Col.Fmt;                  /* Xfer collapse flag     */
        Sn->Col.Start = S->Col.Start;              /* Xfer begin collapse    */
        Sn->Col.Stop = S->Col.Stop;                /* Xfer end collapse      */
        Sn->Col.Sca = S->Col.Sca;                  /* Xfer collapse bin sca  */
        Sn->Col.Pos = S->Col.Pos;                  /* Xfer col beg/end pos   */
        Sn->Col.N = S->Col.N;                      /* Xfer number of bins    */
        Sn->SymSize = S->SymSize;                  /* symbol size            */
        Sn->ScatSym = (I + J) % 10;                /* scatter symbol         */
      break;                                       /* STOP SENSOR OR SCAN    */
      case 6:                                      /* START MODE             */
        Ps = (struct PidfSensor *)P->Sensors;      /* Sensor 0 Info          */ 
        Pm = (struct PidfMode *)P->Modes + N;      /* Mode Info              */ 
        Sn->GetPN = Pm->PidfNum;                   /* Xfer Pidf Get Num      */
        Sn->SenPN = Ps->PidfNum;                   /* Xfer Dummy Pidf Sen #  */
        Sn->GetUN = UnitN;                         /* Xfer Unit Number       */
        Sn->AltUN = S->AltUN;                      /* Xfer Alt Unit Num      */
        Sn->AltSB = S->AltSB;                      /* Xfer Alt Pidf Num      */
        Sn->SymSize = S->SymSize;                  /* symbol size            */
        Sn->ScatSym = (I + J) % 10;                /* scatter symbol         */
      break;                                       /* STOP MODE              */
   }                                               /* BEG DATA TYPE SWITCH   */

   Sn->OneAll = -1;                                 /* Not Parent Sensor     */
   Sn->P = S->P;                                    /* Xfer Project          */
   Sn->M = S->M;                                    /* Xfer Mission          */
   Sn->E = S->E;                                    /* Xfer Experiment       */
   Sn->I = S->I;                                    /* Xfer Instrument       */
   Sn->V = S->V;                                    /* Xfer Project          */
   Sn->DType = S->DType;                            /* Xfer Data Type        */
   Sn->Group = S->Group;                            /* Xfer Group            */
   Sn->MinValid = S->MinValid;                      /* Xfer Min Valid Value  */
   Sn->MaxValid = S->MaxValid;                      /* Xfer Max Valid Value  */
   Sn->PAxis = S->PAxis;                            /* Xfer Plot Axis Number */
   Sn->AddErr = S->AddErr;                          /* Xfer Error Plots      */

   Sn->Key = S->Key;                                /* Xfer Project          */
   Sn->Ver = S->Ver;                                /* Xfer Version          */
   Sn->Pri = 0;                                     /* No Pir Data Memory    */
   Sn->Alt = 0;                                     /* No Alt Data Memory    */
   Sn->Sec = 0;                                     /* No Mesh Mem           */
}
