#include <stdio.h>
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"
#include "util_str.h"

/*****************************************************************************/
/*  This routine determines the starting and ending bin numbers as well as   */
/*  the percent couverage along an axis                                      */
/*****************************************************************************/

void Bins (ByTe_4 N, ByTe_4 SrcN, ByTe_1 Axis, ByTe_4 Index, ByTe_4 *W, 
             ReaL_4 *F)
{
   extern struct UserDefs InFo;
   extern struct WorkArea Wa;

   struct PlotDef *Pd;
   struct SrcInfo *S;
   struct AxisInfo *Ax;
   struct Binning *Bn;

   register ReaL_4 *f1, *Fr, *V;
   register ByTe_4 *Px;

   ReaL_4 Vals[2], VAvg, dV;
   ByTe_2 CnT = 1, DSrc, OSrc;
   ByTe_1 Loc;
   ByTe_1 *Cs, *Sp;

   Pd = (struct PlotDef *)InFo.PlotDefs + N;          /* the plot def struct */
   S = (struct SrcInfo *)Pd->Src + SrcN;              /* pointer to source   */
   V = Vals;                                          /* the values          */
   if (Axis < 4)                                      /* X axis              */
   {                                                  /* BEG X AXIS SETS     */
      DSrc = Pd->AData[0];                            /* axis data source    */
      OSrc = Pd->AData[1];                            /* opposite axis src   */
      Ax = &Pd->Xb;                                   /* bottom X axis info  */
      Bn = &Pd->Bx;                                   /* X binning info      */
   }                                                  /* END X AXIS SETS     */
   else                                               /* one of the Y axis   */
   {                                                  /* BEG Y AXIS SETS     */
      Bn = &Pd->Byl;                                  /* Y binning info      */
      OSrc = Pd->AData[0];                            /* opposite axis src   */
      if (Axis < 6)                                   /* left Y axis         */
      {                                               /* BEG LEFT Y AXIS     */
         DSrc = Pd->AData[1];                         /* axis data source    */
         Ax = &Pd->Yl;                                /* bottom X axis info  */
      }                                               /* END LEFT Y AXIS     */
      else                                            /* need right y info   */
      {                                               /* BEG RIGHT Y AXIS    */
         DSrc = Pd->AData[2];                         /* axis data source    */
         Ax = &Pd->Yr;                                /* bottom X axis info  */
      }                                               /* END RIGHT Y AXIS    */
   }                                                  /* BEG Y AXIS SETS     */
   Cs = (ByTe_1 *)Wa.CStore;                          /* 1 byte data area    */
   Sp = Cs + Pd->SecPos + DSrc;                       /* Sec data offset     */
   
   switch (DSrc)                                      /* Data Source         */
   {                                                  /* BEG DATA SRC SWITCH */
      case 0:                                         /* START TIME CASE     */
        GetPiXeL (N, &S->Bt, Axis, 0, &W[0], &F[0]);  /* beg pixel           */
        GetPiXeL (N, &S->Et, Axis, 1, &W[1], &F[1]);  /* end pixel           */
        if (Bn->Fill == 0)                            /* point not band      */
           W[0] = (W[0] + W[1])/2;                    /* average pixel ok    */
        else                                          /* band storage        */
           CnT = 2;                                   /* returning 2 bins    */
      break;                                          /* STOP TIME CASE      */
      case 1:                                         /* START VALUE         */
        if (OSrc != 7)                                /* no pixel needed     */
        {                                             /* BEG NO PIXEL        */
           CnT = 0;                                   /* no pixel            */
           W[0] = 0;                                  /* pixel number is 0   */
        }                                             /* END NO PIXEL        */
        else                                          /* pixelate it         */
           *V = (S->Col.Fmt > 0) ? S->ColD : *(ReaL_4 *)S->Pri; 
      break;                                          /* STOP VALUE          */
      case 2:                                         /* START SCAN INFO     */
        f1 = (ReaL_4 *)S->Alt + Index;                /* beg values here     */
        if (Bn->Fmt == 0 && Pd->PType != 5)           /* scan indices used   */
           *V = *(f1 + S->DLen);                      /* ending angle        */
        else                                          /* convert scan values */
        {                                             /* BEG CONVERTED SCAN  */
           *V++ = *f1;                                /* start scan info     */
           if (S->AltSca == 'V')                      /* 2nd value           */
           {                                          /* BEG SECOND VALUE    */
              *V = *(f1 + 2 * S->DLen);               /* ending angle        */
              ++CnT;                                  /* returning 2nd bin   */
           }                                          /* END SECOND VALUE    */
        }                                             /* END CONVERTED SCAN  */
      break;                                          /* STOP SCAN INFO      */
      case 3:                                         /* START SPIN ANG CASE */
        f1 = (ReaL_4 *)S->Sec + *Sp * S->DLen;        /* angle data here     */
        Vals[0] = *(f1 + Index);                      /* beginning angle     */
        Vals[1] = *(f1 + Index + S->DLen);            /* ending angle        */
        if (Bn->Fill == 0) {                          /* BEGIN GOOD DATA     */
           dV = Vals[1] - Vals[0];                    /* roll over           */
           VAvg = (Vals[0] + Vals[1])/2.0;            /* average Phase       */
           if ((Bn->Dir == 1 && dV < 0.0) || (Bn->Dir == -1 && dV > 0.0))    
              VAvg += 180.0;
           if (VAvg >= 360.0)
              VAvg -= 360.0;
           CnT = 1;                                   /* single value        */
        }                                             /* END GOOD DATA       */
        else
           CnT = 2;                                   /* returning 2 bins    */

/*
        *V += (*V > Ax->PMax) ? -360. : (*V < Ax->PMin) ? 360. : 0.;
        ++V;
        if (CnT == 2)
           *V += (*V > Ax->PMax) ? -360. : (*V < Ax->PMin) ? 360. : 0.;
*/
        *V += (*V > Ax->Max) ? -360. : (*V < Ax->Min) ? 360. : 0.;
        ++V;
        if (CnT == 2)
           *V += (*V > Ax->Max) ? -360. : (*V < Ax->Min) ? 360. : 0.;

      break;                                          /* STOP SPIN ANG CASE  */
      case 5:                                         /* START THETA CASE    */
        if (Bn->Fmt == 0 && S->Col.Fmt < 0)           /* scan indices used   */
        {                                             /* BEG ARRAY INDICES   */
           f1 = (ReaL_4 *)S->Alt + Index + S->DLen;   /* array index here    */
           *V++ = *f1;                                /* xfer it             */
        }                                             /* END ARRAY INDICES   */
        else                                          /* real values         */
        {                                             /* BEG THETA VALUE     */
           f1 = (ReaL_4 *)S->Sec + *Sp * S->DLen;     /* beg angle here      */
           Vals[0] = *(f1 + Index);                   /* beginning theta     */
           Vals[1] = *(f1 + Index + S->DLen);         /* ending theta        */
           if (Bn->Fill == 0)                         /* point not band      */
              Vals[0] = (Vals[0] + Vals[1])/2.0;      /* average Theta       */
           else                                       /* use upper and lower */
              CnT = 2;                                /* returning 2 bins    */
        }                                             /* END THETA VALUE     */
      break;                                          /* STOP SPIN ANG CASE  */
      case 6:                                         /* START SEN/COL VALUE */
        *V = (S->SType == 3) ? S->SenCN : S->SenVN;   /* value               */ 
      break;                                          /* STOP SEN/COL VALUE  */
      case 7:                                         /* START VALUE POINTS  */
        CnT = 0;                                      /* no pixel            */
        W[0] = 0;                                     /* pixel number is 0   */
      break;                                          /* STOP VALUE          */
      case 9:                                         /* START ANC SCAN INFO */
        f1 = (ReaL_4 *)S->Alt + 4 * S->DLen + Index;  /* beg values here     */
           *V = *f1;                                  /* ending angle        */
      break;                                          /* STOP VALUE          */
   }                                                  /* END DATA SRC SWITCH */

   if (DSrc != 0)                                     /* non-time base       */ 
   {                                                  /* BEG NON-TIME DATA   */
      Px = W;                                         /* pointer to bin #    */
      Fr = F;                                         /* ptr to frac of bin  */
      V = Vals;                                       /* ptr to data vals    */
      for (Loc = 0; Loc < CnT; ++Loc)                 /* get bin loop        */
          GetBin (N, Axis, *V++, Px++, Fr++, Loc);    /* return bin value    */
   }                                                  /* BEG NON-TIME DATA   */

   if (CnT <= 1)                                      /* only 1 bin          */
   {                                                  /* BEG ONE BIN         */
      W[1] = W[0];                                    /* fill second         */
      F[0]  = 1.0;                                    /* set 1st frac to 1   */
      F[1]  = 1.0;                                    /* set 2nd frac to 1   */
   }                                                  /* BEG ONE BIN         */
   else                                               /* did 2 bins          */
   {                                                  /* BEG 2 BIN CHECK     */
      if (W[1] == W[0])                               /* same bin            */
      {                                               /* BEG SAME BIN        */
         F[0]  = F[0] + F[1] - 1.0;                   /* set 1st frac true   */
         if (F[0] < .00001)                           /* not to small        */
             F[0] = .00001;                           /* set to small        */
         F[1]  = 1.0;                                 /* set 2nd frac to 1   */
      }                                               /* BEG SAME BIN        */
   }                                                  /* END 2 BIN CHECK     */
}
