#include <stdio.h>

#include "UDFpltDefs.h"
#include "UDFpltStr.h"
#include "UDFpltAnsi.h"

ByTe_1 BegTmTick (ByTe_1 BaseTm, ByTe_4 *NextMj, ByTe_4 dMj, ReaL_4 dMn, 
                  struct TiMiNg *Tm)
{
   struct TiMiNg Tmp;

   ByTe_4 T, Tf, IncMs;
   ByTe_4 MnSep, Beg, Dy;
   ByTe_1 TickFmt;

   MnSep = dMn;                                    /* integer minor tic sep  */
   switch (BaseTm)                                 /* switch by time base    */
   {                                               /* BEG TIME BASE SWITCH   */
      case 0:                                      /* START YEAR BASE TIME   */
      break;                                       /* STOP YEAR BASE TIME    */
      case 1:                                      /* START DAY BASE TIME    */
         T = Tm->Ms / 3600000;                     /* beginning hour         */ 
         Tf = Tm->Ms % 3600000;                    /* any fractional hours   */ 
         Beg = T / MnSep;                          /* Minor ticks to beg Hr  */
         if (((T % MnSep) != 0) || Tf != 0)        /* adv to tick? on tick?  */
         {                                         /* BEG GO TO TICK         */
            Tm->Ms = (Beg + 1) * MnSep * 3600000;  /* next tick at this hour */ 
            Dy = RollTime (Tm, 0, 0);              /* correct time           */
         }                                         /* END GO TO TICK         */
         if (Tm->Ms == 0)                          /* this is a major tick   */
         {                                         /* BEG MAJOR TICK         */
            TickFmt = 2;                           /* set major tick         */
            *NextMj = Tm->Dy + dMj;                /* next major tick mark   */
         }                                         /* END MAJOR TICK         */
         else                                      /* hmmm - minor tick      */
         {                                         /* BEG MINOR TICK         */
            TickFmt = 3;                           /* set minor tick         */
            Tmp.Yr = Tm->Yr;                       /* current year           */
            Tmp.Dy = Tm->Dy;                       /* current day            */
            Tmp.Ms = Tm->Ms;                       /* current millisecond    */
            while (Tmp.Ms != 0)                    /* search for 1st mj tick */
            {                                      /* BEG MAJOR TICK SEARCH  */
               IncMs = MnSep * 3600000;            /* tm inc to next mn tick */ 
               *NextMj = RollTime (&Tmp, 0, IncMs); /* set next major        */
            }                                      /* END MAJOR TICK SEARCH  */
         }                                         /* END MINOR TICK         */
      break;                                       /* STOP DAY BASE TIME     */
      case 2:                                      /* START HOUR BASE TIME   */
         T = Tm->Ms / 60000;                       /* beginning minute       */ 
         Tf = Tm->Ms % 60000;                      /* any fractional minutes */ 
         Beg = T / MnSep;                          /* Minor ticks to beg Min */
         if (((T % MnSep) != 0) || Tf != 0)        /* adv to tick? on tick?  */
         {                                         /* BEG GO TO TICK         */
            Tm->Ms = (Beg + 1) * MnSep * 60000;    /* next tick at this min  */ 
            Dy = RollTime (Tm, 0, 0);              /* correct time           */
         }                                         /* END GO TO TICK         */
         if ((Tm->Ms % 3600000) == 0)              /* this is a major tick   */
         {                                         /* BEG MAJOR TICK         */
            TickFmt = 2;                           /* set major tick         */
            *NextMj = Tm->Ms + 3600000 * dMj;      /* next major tick mark   */
            if (*NextMj > 86400000)                /* in next day?           */
               *NextMj -= 86400000;                /* correct it             */
         }                                         /* END MAJOR TICK         */
         else                                      /* hmmm - minor tick      */
         {                                         /* BEG MINOR TICK         */
            TickFmt = 3;                           /* set minor tick         */
            Tmp.Yr = Tm->Yr;                       /* current year           */
            Tmp.Dy = Tm->Dy;                       /* current day            */
            Tmp.Ms = Tm->Ms;                       /* current millisecond    */
            while ((Tmp.Ms % 3600000) != 0)        /* search for 1st mj tick */
            {                                      /* BEG MAJOR TICK SEARCH  */
               IncMs = MnSep * 60000;              /* tm inc to next mn tick */ 
               Dy = RollTime (&Tmp, 0, IncMs);     /* update time            */
            }                                      /* END MAJOR TICK SEARCH  */
            *NextMj = Tmp.Ms;                      /* next major tick here   */ 
         }                                         /* END MINOR TICK         */
      break;                                       /* STOP HOUR BASE TIME    */
      case 3:                                      /* START MIN BASE TIME    */
         T = Tm->Ms / 1000;                        /* beginning second       */ 
         Tf = Tm->Ms % 1000;                       /* any fractional second */ 
         Beg = T / MnSep;                          /* Minor ticks to beg Min */
         if (((T % MnSep) != 0) || Tf != 0)        /* adv to tick? on tick?  */
         {                                         /* BEG GO TO TICK         */
            Tm->Ms = (Beg + 1) * MnSep * 1000;     /* next tick at this min  */ 
            Dy = RollTime (Tm, 0, 0);              /* correct time           */
         }                                         /* END GO TO TICK         */
         if ((Tm->Ms % 60000) == 0)                /* this is a major tick   */
         {                                         /* BEG MAJOR TICK         */
            TickFmt = 2;                           /* set major tick         */
            *NextMj = Tm->Ms + 60000 * dMj;        /* next major tick mark   */
            if (*NextMj > 86400000)                /* in next day?           */
               *NextMj -= 86400000;                /* correct it             */
         }                                         /* END MAJOR TICK         */
         else                                      /* hmmm - minor tick      */
         {                                         /* BEG MINOR TICK         */
            TickFmt = 3;                           /* set minor tick         */
            Tmp.Yr = Tm->Yr;                       /* current year           */
            Tmp.Dy = Tm->Dy;                       /* current day            */
            Tmp.Ms = Tm->Ms;                       /* current millisecond    */
            while ((Tmp.Ms % 60000) != 0)          /* search for 1st mj tick */
            {                                      /* BEG MAJOR TICK SEARCH  */
               IncMs = MnSep * 1000;               /* tm inc to next mn tick */ 
               Dy = RollTime (&Tmp, 0, IncMs);     /* update time            */
            }                                      /* END MAJOR TICK SEARCH  */
            *NextMj = Tmp.Ms;                      /* next major tick here   */ 
         }                                         /* END MINOR TICK         */
      break;                                       /* STOP MIN BASE TIME     */
      case 4:                                      /* START MSEC BASE TIME   */
         T = Tm->Ms;                               /* beginning msec         */ 
         Tf = 0;                                   /* any fractional minutes */ 
         Beg = T / MnSep;                          /* Minor ticks to beg Min */
         if (((T % MnSep) != 0) || Tf != 0)        /* adv to tick? on tick?  */
         {                                         /* BEG GO TO TICK         */
            Tm->Ms = (Beg + 1) * MnSep;            /* next tick at this msec */ 
            Dy = RollTime (Tm, 0, 0);              /* correct time           */
         }                                         /* END GO TO TICK         */
         if ((Tm->Ms % 1000) == 0)                 /* this is a major tick   */
         {                                         /* BEG MAJOR TICK         */
            TickFmt = 2;                           /* set major tick         */
            *NextMj = Tm->Ms + 1000 * dMj;         /* next major tick mark   */
            if (*NextMj > 86400000)                /* in next day?           */
               *NextMj -= 86400000;                /* correct it             */
         }                                         /* END MAJOR TICK         */
         else                                      /* hmmm - minor tick      */
         {                                         /* BEG MINOR TICK         */
            TickFmt = 3;                           /* set minor tick         */
            Tmp.Yr = Tm->Yr;                       /* current year           */
            Tmp.Dy = Tm->Dy;                       /* current day            */
            Tmp.Ms = Tm->Ms;                       /* current millisecond    */
            while ((Tmp.Ms % 1000) != 0)           /* search for 1st mj tick */
            {                                      /* BEG MAJOR TICK SEARCH  */
               IncMs = MnSep;                      /* tm inc to next mn tick */ 
               Dy = RollTime (&Tmp, 0, IncMs);     /* update time            */
            }                                      /* END MAJOR TICK SEARCH  */
            *NextMj = Tmp.Ms;                      /* next major tick here   */ 
         }                                         /* END MINOR TICK         */
      break;                                       /* STOP MSEC BASE TIME    */
      case 5:                                      /* START MSEC BASE TIME   */
      case 6:                                      /* START USEC BASE TIME   */
      case 7:                                      /* START NSEC BASE TIME   */
      break;                                       /* STOP SECS BASE TIME    */
   }                                               /* END TIME BASE SWITCH   */

   return (TickFmt);
}
