# THIS procedure installs a tcl software package.  There are a number of 
#   options which are identical to the generic software install procedure.
#   In fact this procedure parallels the generic procedure with the exception
#   that it does not make use of the AcTioN inputs which it already knows.
#
#  pdB    - The database entry that came with the package.  What is used
#              from that array is"
#
#    pdB(DIR) - The directory information.  This is a listing of all of the
#               the directories which are used in this install.  The format
#               is A+B+C+D^E+F
#               where:
#                  A is the Home base package directory and is the environment
#                    variable from which is it derived (eg UDF_HOME)
#                  B,C,D are the directories needed to make up the package 
#                    directory. D is the directory in which the package is
#                    unpacked.
#                  E,F are any directories under D which need to be removed
#                    in the deinstall process.  Most notably this would be
#                    the C-Code directories under some of the Tcl packages
#
#   pdB(PKG)  - The package name (less the version-revision-.tar info)
#   pdB(REV)  -  The package revision 
#   pbB(OPT)  - A list which describes what needs to be done. Elements are
#              (0)  1 if a .a make needs be done; 2 if a .so make else 0 
#              (1)  name of program to link if an executable is built; else ""
#              (2)  1 if a release is done; 0 otherwise
#              (3)  List of any files to move to the bin directory under pBaSe 
#                   Multiple files are separated by +'s
#              (4)  1 if a pkgIndex needs to be done
#              (5)  1 if purge the home directory; 0 otherwise
#              (6)  1 no overwrite of existing package (also no InstalledPKGS 
#                   update)
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUtclInstall { pdB } {
   global env auANS SySCmDs cOPTS tcl_platform

   upvar $pdB pI

# FLAG WINDOIWS based platforms; Flags are 0 UNIX/Linus/OSX, 2 WINDOWS native,
#    1 WINDOWS/CYGWIN

   if [string match window* $tcl_platform(platform)] {
      if [string match NO $cOPTS(CYGWIN)] { set SyS 2 } else { set SyS 1 }
   } else { set SyS 0 }
   
# BUILD the makes

   AUsetMakes

# THIS is the default action list

   set dLen [llength $auANS(dOPTS)]

   set owd [pwd]

# FILL in any of the action list elements not accounted for

  set AcTioN $pI(OPT)
  set AcTioN [split $AcTioN "|"]
  set aLen [llength $AcTioN] 
  for { set I $aLen } { $I < $dLen } { incr I } {
     lappend AcTioN [lindex $auANS(dOPTS) $I]
  }

# GET all of the directories which we will need.  This consists of the
#    package base directory, the package home directory, and the directory
#    which holds the InstalledPKG file.

   set dInFo $pI(DIR)
   set diRs [split $dInFo "^"]
   set dInFo [split [lindex $diRs 0] "+"] 
   set dLen [llength $dInFo]

   set pBaSe $env([lindex $dInFo 0])
   set pHoMe $env([lindex $dInFo 0])
   set INSHOME [file join $pBaSe INSTALLED]
   if ![file exists $INSHOME] { file mkdir $INSHOME }
   for { set I 1 } { $I < $dLen } { incr I } {
      set pHoMe [file join $pHoMe [lindex $dInFo $I]] 
   }

# FORM the base package name

   set bPkg $pI(PKG).$pI(REV)

# DELETE the directories the package will create and then recreate them.  
#    This purges the old version if any was present.

   if [lindex $AcTioN 5] { 
      set LeN [llength $diRs]
      if { $LeN > 0 } {
         set suBs [split [lindex $diRs 1] "+"] 
      } else { set suBs "" }
      AUdirCntrl $pHoMe $suBs REMOVEALL
   }
   AUdirCntrl $pHoMe "" CREATE

#  NOW install the package.  This consists of moving it to its home directory,
#     unzipping it, untarring it and then doing any needed makes or moves.

   file rename -force $bPkg.tgz [file join $pHoMe $bPkg.tgz] 

   cd $pHoMe
   exec $SySCmDs(gzip) -df $bPkg.tgz
   exec $SySCmDs(tar) xmf $bPkg.tar
   if [file exists $bPkg.tar] { file delete -force $bPkg.tar }

# If there are executables which need to be moved into a bin directory
#   do that now

   cd $owd
   set mvThese [split [lindex $AcTioN 3] "+"]
   set mvExT [split [lindex $AcTioN 8] "+"]
   set mLen [llength $mvThese]
   set eLen [llength $mvExT]
   if { $mLen > 0 } {
      for { set I 0 } { $I < $mLen } { incr I } {
         set mVF [lindex $mvThese $I]
         if { [llength [split $mVF ":"]] == 1 } {
             set bHoMe [file join $pBaSe bin]
             set Mv $mVF
         } else {
             set bHoMe [file join $env([lindex [split $mVF ":"] 0]) bin]
             set Mv [lindex [split $mVF ":"] 1]
         }

         if { ($eLen > 0) && ($SyS == 2) } {
            set ExT [lindex $mvExT $I]
            if { [string length $ExT] > 0 } { 
               set MvA $Mv.$ExT 
            } else { set MvA $Mv }
         } else { set MvA $Mv }

         if ![file isdirectory $bHoMe] { file mkdir $bHoMe }
         file rename -force [file join $pHoMe $Mv] [file join $bHoMe $MvA]
      }
   }

# If there is a C-Code directory then we need to go into it an do a 
#    shared object make.  We can only do this however if the tcl.h
#    include file exists.  Also we do not compile if this is a native
#    windows installation.

   set cHoMe [file join $pHoMe C-Code]
   if [file isdirectory $cHoMe] {
      if [info exists env(TCL_INCLUDE)] {
         set tH [file join $env(TCL_INCLUDE) tcl.h]   
      } else { set tH [file join / usr include tcl.h] }   
      if [file exists $tH] {
         set OK 1
         cd $cHoMe
         if { $SyS < 2 } { catch { eval exec $auANS(MaKeS) } }
         catch { pkg_mkIndex $cHoMe }
      }
   }

# NEED to make the package index file

   pkg_mkIndex $pHoMe 

# AND need to register the package

   AUupdateDb $INSHOME pI

   cd $owd

   return 1
}
