# THIS builds the make calls.

package provide AutoUpdate 1.0

proc AUsetMakes { {Opts ""} } {
   global env auANS cOPTS

   set nL [llength $Opts]
   for { set I 0 } { $I < $nL } { incr I } {
      set OpT [split [lindex $Opts $I] "|"]
      set newOPTS([lindex $OpT 0]) [lindex $OpT 1]
   } 

   if [info exists newOPTS(CBASE)] {
      set CF "CADD=$newOPTS(CBASE)"
   } else { set CF "CADD=$cOPTS(CBASE)" }

   if [info exists newOPTS(CSYS)] {
      append CF " $newOPTS(CSYS)"
   } else { append CF " $cOPTS(CSYS)" }

   if [info exists newOPTS(CADD)] {
      append CF " $newOPTS(CADD)"
   } elseif [info exists cOPTS(CADD)] {
      append CF " $cOPTS(CADD)"
   }

   if [info exists newOPTS(CSO)] {
      set CSO "CSO=$newOPTS(CSO)"
   } elseif [info exists cOPTS(CSO)] {
      set CSO "CSO=$cOPTS(CSO)"
   } else { set CSO "CSO=-fPIC -shared" }

   if [info exists newOPTS(LD_FLAGS)] {
      set LF "LD_FLAGS=$newOPTS(LD_FLAGS)"
   } elseif [info exists cOPTS(LD_FLAGS)] {
      set LF "LD_FLAGS=$cOPTS(LD_FLAGS)"
   } else { set LF "LD_FLAGS=-shared" }

   if [info exists newOPTS(SO_EXT)] {
      set SOX "SO_EXT=$newOPTS(SO_EXT)"
   } elseif [info exists cOPTS(SO_EXT)] {
      set SOX "SO_EXT=$cOPTS(SO_EXT)"
   } else { set SOX "SO_EXT=so" }

   if [info exists newOPTS(LD)] {
      set LD "LD=$newOPTS(LD)"
   } elseif [info exists cOPTS(LD)] {
      set LD "LD=$cOPTS(LD)"
   } else { set LD  "LD=ld" }

   if [info exists newOPTS(CTYPE)] {
      set CT "CTYPE=$newOPTS(CTYPE)"
   } elseif [info exists cOPTS(CTYPE)] {
      set CT "CTYPE=$cOPTS(CTYPE)"
   } else { set CT  "CTYPE=SHARED" }

   set auANS(MaKe)  [list make $CF $CT $CSO $LF $SOX $LD]
   set auANS(MaKeE) [list make $CF $CT $CSO $LF $SOX $LD]
   set auANS(MaKeS) [list make $CF $CT $CSO $LF $SOX $LD]
   set auANS(MaKeR) [list make $CT $SOX release]

   if [info exists cOPTS(RL) ] { lappend auANS(MaKe) RANLIB=$cOPTS(RL) }

   if [info exists cOPTS(EXT)] {
      lappend auANS(MaKeE) "EXT=$cOPTS(EXT)"
      lappend auANS(MaKeR) "EXT=$cOPTS(EXT)"
   }

   if [info exists auANS(XLIB)] {
      lappend auANS(MaKeE) "XLIB=$auANS(XLIB)"
      set auANS(XLIB) $auANS(XLIB)
   } elseif [info exists XLIB] {
      lappend auANS(MaKeE) "XLIB=$auANS(XLIB)"
   }

   return 1
}
