# THIS procedure does some special GPH  checks.  
#
# GMAPS - swap the bytes if necessary
# GPRIMITIVES, GXWINDOW - check if X should be turned off
# GDATAFILES - more swapping
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUpkgSpecial { PkG } {
   global env tcl_platform

   switch -exact -- $PkG {
      GDATAFILES {
         set ByTeOrDeR $tcl_platform(byteOrder)
         if [string match big* $ByTeOrDeR] {
            set tBn S ; set tBa s
            set fBn I ; set fBa i
         } else {
            set tBn s ; set tBa S
            set fBn i ; set fBa I
         }

         set fList [list pwritxc1.bin pwritxc2.bin pwritxd1.bin pwritxd2.bin]
         set iD    [list  2 23208 2 23208]

         for { set I 0 } { $I < 4 } { incr I } {
            set fName [file join $env(GPH_HOME) datafiles [lindex $fList $I]]
            if { [file exists $fName] == 1 } {
               if [catch {open $fName r+} fd]  {
                  puts stderr "UNABLE TO CHECK $fName"
               } else {
                  fconfigure $fd -translation binary
                  seek $fd 0 end
                  set EnD [tell $fd]
                  set nE [expr $EnD / 2]
                  seek $fd 0 start
                  binary scan [read $fd 2] $tBn TmP
                  if { $TmP != [lindex $iD $I] } {
                     seek $fd 0 start
                     binary scan [read $fd $EnD] ${tBa}$nE TmP
                     seek $fd 0 start
                     puts -nonewline $fd [binary format ${tBn}$nE $TmP]
                  }
                  close $fd
               }
            }
         }
      }

      GMAPS {
         set ByTeOrDeR $tcl_platform(byteOrder)
         if [string match big* $ByTeOrDeR] {
            set tBn S ; set tBa s
            set fBn I ; set fBa i
         } else {
            set tBn s ; set tBa S
            set fBn i ; set fBa I
         }

         set fList [list ASIA.CIL  EURAFR.CIL  NAMERICA.CIL  SAMERICA.CIL] 
         set iD    [list  379 449 2854 1530 ]
         for { set I 0 } { $I < 4 } { incr I } {
            set fName [file join $env(GPH_HOME) mapdata [lindex $fList $I]]
            if { [file exists $fName] == 1 } {
               if [catch {open $fName r+} fd]  {
                  puts stderr "UNABLE TO CHECK $fName"
               } else {
                  fconfigure $fd -translation binary
                  seek $fd 0 end
                  set EnD [tell $fd]
                  seek $fd 0 start
                  binary scan [read $fd 4] $fBn TmP
                  if { $TmP != [lindex $iD $I] } {
                     set BeG 0 
                     set nB 100000
                     set nE 25000
                     while { $EnD >= $nB } {
                        seek $fd $BeG start
                        binary scan [read $fd $nB] ${fBa}$nE TmP
                        seek $fd $BeG start
                        puts -nonewline $fd [binary format ${fBn}$nE $TmP]
                        incr EnD [expr -$nB]
                        set BeG $nB
                     }
                     if { $EnD != 0 } {
                        seek $fd $BeG start
                        set nE [expr $EnD / 4]
                        binary scan [read $fd $EnD] ${fBa}$nE TmP
                        seek $fd $BeG start
                        puts -nonewline $fd [binary format ${fBn}$nE $TmP]
                     }
                  }
                  close $fd
               }
            }
         }
      }
      LIBCSRC {
         set Home [file join $env(UDFTOOL_HOME) GMenu]
         AUdirCntrl $Home [list include] CREATE        
      }
      MAINTENANCE {
         set ltb [file join $env(GPH_HOME) maintenance list_to_bin]
         if ![file exists $ltb] {
         } else { exec $ltb }
      }
      GINCLUDES { AUgphX }
   }
}
