# THIS procedure deinstalls a software package. 
                                                                                
package provide AutoUpdate 1.0

proc AUpkgNuke { W } {
   global env auANS SySCmDs tcl_platform cOPTS

# FLAG WINDOIWS based platforms; Flags are 0 UNIX/Linus/OSX, 2 WINDOWS native,
#    1 WINDOWS/CYGWIN

   if [string match window* $tcl_platform(platform)] {
      if [string match NO $cOPTS(CYGWIN)] { set SyS 2 } else { set SyS 1 }
   } else { set SyS 0 }

# THIS is the selected package information

   set PkGs [split [$W curselection] ]
   set PkGs [lsort -integer -decreasing $PkGs]
   set pLen [llength $PkGs]

# THIS is the number of PKGS being displayed.  The selected package(s) will
#   be a subset of one of them.
   
   set nP  [llength $auANS(PKGS)]

# LOOP over the selections

   for { set I 0 } { $I < $pLen } { incr I } {

# GET the information on the selected line

      set sN [lindex $PkGs $I]
      set pLiNe [$W get $sN ] 
      scan $pLiNe "%10s%14s%11s%11s" pName pElement iRev pRev

# CHECK to make sure that this package is removable.  There are protected
#   packages which you can't remove.  Removing these would cripple the
#   udfLibrarian   

      set ChK $pName,$pElement
      if { [lsearch $auANS(PKGPROT) $ChK] >= 0 } {
         GUImsgPopUp .msgWin -1 3 \
	     [list "CAN'T DELETE PACKAGE $pElement" "PACKAGE IS PROTECTED"]
	 continue
      }

      set pdB [lindex $auANS(PDBS) [lsearch $auANS(PKGS) $pName]]
      set P [lsearch $auANS(ipkg,$pdB) $pElement]

      if { $P >= 0 } {
         set pI(PKG) [lindex $auANS(ipkg,$pdB) $P]
         set pI(OPT) [lindex $auANS(iopt,$pdB) $P]
         set pI(DIR) [lindex $auANS(idir,$pdB) $P]

# GET all of the directories which we will need.  This consists of the
#    package base directory, the package home directory, and the directory
#    which holds the InstalledPKG file.  Nuke all those which hold the
#    the package files.

         set dInFo $pI(DIR)
         set diRs [split $dInFo "^"]
         set dInFo [split [lindex $diRs 0] "+"]
         set dLen [llength $dInFo]

         set pBaSe $env([lindex $dInFo 0])
         set pHoMe $env([lindex $dInFo 0])
         for { set J 1 } { $J < $dLen } { incr J } {
	    set pHoMe [file join $pHoMe [lindex $dInFo $J]]
	 }

         set LeN [llength $diRs]
         if { $LeN > 0 } {
            set suBs [split [lindex $diRs 1] "+"]
         } else { set suBs "" }
         AUdirCntrl $pHoMe $suBs REMOVEALL

# Now nuke all the files which went into the bin directory.

         set oPFlds [split $pI(OPT) "|"]
         set dThese [split [lindex $oPFlds 3] "+"]
         set dExT [split [lindex $oPFlds 8] "+"]
         set mLen [llength $dThese]
         set eLen [llength $dExT]

         for { set J 0 } { $J < $mLen } { incr J } {
            set fIle [lindex $dThese $J]
            set eXt  [lindex $dExT $J]
	    if { $SyS == 2 } {
	       if { [string length $eXt] > 0 } { append fIle ".$eXt" }
            }
	    set Elem [split $fIle ":"]
            if { [llength $Elem] == 1 } {
               set bHoMe [file join $pBaSe bin]
               set rmF $fIle
            } else {
               set bHoMe [file join $env([lindex $Elem 0]) bin]
               set rmF [lindex $Elem 1]
            }
            file delete -force [file join $bHoMe $rmF]
         }
         AUupdateDb [file join $pBaSe INSTALLED] pI 1
         $W delete [lindex $PkGs $I]
      }
   }
}
