# THIS procedure checks the dependencies of package being installed has any
#   dependencies and if so are they in place?
#
#  pdB    - The database entry that came with the package.  What is used
#              from that array is"
#
#    pdB(DIR) - The directory information.  This is a listing of all of the
#               the directories which are used in this install.  The format
#               is A+B+C+D^E+F
#               where:
#                  A is the Home base package directory and is the environment
#                    variable from which is it derived (eg UDF_HOME)
#                  B,C,D are the directories needed to make up the package 
#                    directory. D is the directory in which the package is
#                    unpacked.
#                  E,F are any directories under D which need to be removed
#                    in the deinstall process.  Most notably this would be
#                    the C-Code directories under some of the Tcl packages
#
#   pdB(PKG)  - The package name (less the version-revision-.tar info)
#   pdB(REV)  - The package revision 
#   pbB(OPT)  - A list which describes what needs to be done. Elements are
#              (0)  1 if a .a make needs be done; 2 if a .so make else 0 
#              (1)  name of program to link if an executable is built; else ""
#              (2)  1 if a release is done; 0 otherwise
#              (3)  List of any files to move to the bin directory under pBaSe 
#                   Multiple files are separated by +'s
#              (4)  1 if a pkgIndex needs to be done
#              (5)  1 if purge the home directory; 0 otherwise
#              (6)  1 no overwrite of existing package (also no InstalledPKGS 
#                   update)
#              (7)  0 if no AUpkgSpecial, 1 if AUpkgSpecial pre Make, 
#                   2 if AUpkgSpecial post Make, 
#   pbB(DEP)  - A of the dependencies of the package.  This consists of a set
#               of packages as PDB:PKG:REV+PDB:PKG:REV.  REV can be omitted 
#               in which case it is assumed to be any revision.  The 
#               dependency UDFCORE and GPHCORE indicated that the entire 
#               UDF or GPH core packages must be installed.
                                                                                
package provide AutoUpdate 1.0
                                                                                
proc AUdepCheck { PkG PkGNo} {
   global env auANS SySCmDs

   set InS ""

# InS is the package status which is either empty if there is no install
#   needed or is a list of the package element, database, and revision

   set pInfo [split [lindex $PkG $PkGNo] ","]
   set nE [llength $pInfo]
   if { $nE == 1 } { 
       set pElement [lindex $pInfo 0]
   } else { set pElement [lindex $pInfo 1] } 

   switch -exact -- $pElement {
      UDFCORE {
         if { $auANS(udfIns) != 1 } { set InS [list UDFCORE UDF LATEST] } 
      }
      GPHCORE {
         if { $auANS(gphIns) != 1 } { set InS [list GPHCORE GPH LATEST] } 
      }
      default {
         set Index [lsearch $auANS(pID) [lindex $pInfo 0]]
         set PkG [lindex $auANS(PKGS) $Index]
         set PdB [lindex $auANS(PDBS) $Index]
         set P [lsearch $auANS(ipkg,$PdB) $pElement]
         if { $P >= 0 } {
            if {$nE == 3 } {
               set ReV [lindex $pInfo 2]
               set rEv [lindex $auANS(irev,$PdB) $P]
     	       if { [AUrevCmp $ReV $rEv] == 1 } {
                  set InS [list $pElement $PkG LATEST]
	       }
            }
         } else { set InS [list $pElement $PkG LATEST] }
      }
   }

   return $InS
}
