package provide TclUtils 1.0 

#  TIME diff returns the difference T2 - T1 of two times either in 
#     MS, SEC, or DAYS (OutFmT = 0, 1, 2 respectively).
#
#  TIMES are entered as lists. InFmT gives the input Format  

#   FORMAT               INPUT               
# ---------   -----------------------------  
#     0        Yr Dy Msec                 
#     1        Yr Dy Msec Nsec         
#     2        Yr Dy
#     3        Yr Dy Hr
#     4        Yr Dy Hr Mn
#     5        Yr Dy Hr Mn Sec
#     6        Yr Dy Hr Mn Sec Msec 
#     7        Yr Dy Hr Mn Sec Msec NSec 

proc TUtimeDiff { InFmT T1 T2 OutFmT } {

   set BYr [lindex $T1 0]
   set EYr [lindex $T2 0]
   set BDy [lindex $T1 1]
   set EDy [lindex $T2 1]

   set BMs 0 ; set BNs 0 ; set BHr 0 ; set BMn 0 ; set BSc 0
   set EMs 0 ; set ENs 0 ; set EHr 0 ; set EMn 0 ; set ESc 0

   if { $InFmT  < 2 } {
      set BMs [lindex $T1 2]
      set EMs [lindex $T2 2]
      if { $InFmT ==  1 } {
         set BMs [lindex $T1 3]
         set EMs [lindex $T2 3]
      }
   } else {
      set lLen [llength $T1]
      set Mult [list 0 0 3600000 60000 10000 1 0]
      for { set I 2 } { $I < $lLen } { incr I } {
         set BMs [expr $BMs + [lindex $T1 $I] * [lindex $Mult $I] ]
         set EMs [expr $EMs + [lindex $T2 $I] * [lindex $Mult $I] ]
      }

      if { $lLen == 7 } {
         set BMs [lindex $T1 3]
         set EMs [lindex $T2 3]
      }
   }

   set dT1 [expr ($BDy -1) * 86400000 + $BMs] 

   set dT2 0
   for { set I $BYr } { $I < $EYr } { incr I } {     
      set dT2 [expr $dT2 + [TUyearLeap $I] * 86400000 ]
   }
   set dT2 [expr $dT2 + ($EDy -1) * 86400000 + $EMs] 

   set rV -1
   switch -exact -- $OutFmT {
      0 { set rV [expr $dT2 - $dT1 ] }
      1 { set rV [expr ($dT2 - $dT1) / 1000.0 ] }
      2 { set rV [expr ($dT2 - $dT1) / 86400000.0 ] }
   }

   return $rV
}
