# GENERIC procedure to return the basis functions for a set of spherical 
#   harmonics.  Note that X is the phase input in degrees and Y is the
#   cosine of the elevation.  nO is the order (lmax value) used.
#   This is taylored for use in TUdataLSq2D

package provide TclUtils 1.0

proc TUsphFunc { X Y cM nO nC } {
   global RtoD PI

   upvar $cM cF

   if { $nC <= 0 } {
      set nC 1;
      for { set I 1 } { $I <= $nO } { incr I } {
         set nC [expr $nC + 2 * $I + 1]
      }
   }

   set I 0

   for { set M 0 } { $M <= $nO } { incr M } {
      set A($I) 1.0
      if { $M > 0 } { 
         set F [expr sqrt((1.0 + $Y ) * (1.0 - $Y))]
         set G 1.0
         for { set J 0 } { $J < $M } { incr J } {
            set A($I) [expr -$A($I) * $G * $F]
            set G [expr $G + 2.0]
         } 
      } 
      set J $I
      set K [expr $I - 1]
      incr I
      set N [expr $M + 1]
      for { set L $N } { $L <= $nO } { incr L } {
         if { $L == $N } {
            set A($I) [expr $Y * (2 * $M  + 1) * $A($J) ] 
         } else {
            set dI [expr $L - $M]
            set A($I) [expr ( $Y * (2.0 * $L  - 1.0) * $A($J) - \
                            ($L + $M - 1.0) * $A($K) ) / $dI ]
         }
         incr I ; incr J ; incr K
      }
   }

   set X [expr $X / $RtoD] 
   set fP [expr 1.0 / (4.0 * $PI)]

   set I 0
   set J 0
   set cF(0) $A(0) 
   for { set M 0 } { $M <= $nO } { incr M } {
      set cX [expr cos($M * $X)]
      set sX [expr sin($M * $X)]
      for { set L $M } { $L <= $nO } { incr L } {
         if { $M != 0 } {
            set cF($I) [expr $A($J) * $sX] ; incr I 
            set cF($I) [expr $A($J) * $cX] ; incr I ; incr J 
         } else {
            set cF($I) $A($J)  
	    incr I ; incr J
         }
      }
   }

   return $nC
}
