# FIND the  solutions to the Quadratic equation of the form
#                  Ax^2 + Bx + C = 0
#
#  MANUAL PAGE
#     Generated

package provide TclUtils 1.0

proc TUsolveQuadratic { A B C } {

# SOLVE for the descriminant

   set Q [expr $B * $B - 4.0 * $A * $C]

# SET the correct sign to use

   if {$B < 0.0 } { set SgN -1.0 } else { set SgN 1.0 }

# IF the descriminent is >= 0 then we have real roots otherwise imaginary.
#   Order the real roots so that the first value in the list is the smaller
#   of the two.  
#
#   Because the imaginary roots are complex conjugates of one another just
#   solve for one of the roots and set the second to the complex conjugate
#   of the first.

   if { $Q >= 0.0 } {
      set q [expr -($B + $SgN * sqrt($Q))/2.0]
      set r1  [expr $q / $A]
      set r2  [expr $C / $q]
      if { $r1 > $r2 } {
         set rV [list $r2 $r1]
      } else { set rV [list $r1 $r2] }
   } else {
      set p [expr 2 * $A]
      set r1 [expr -$B/$p]
      set i1 [expr $SgN * sqrt(abs($Q))/$p ]
      set i2 [expr -$i1]
      set rV [list $r1 $r1 $i1 $i2]
   }

   return $rV
}
