# CREATES A SET OF SAVITSKY-GOLAY COEFFICIENTS
#
#  Inputs   Coef   :  Coefficient array
#           nC     :  Number of coefficients
#           nL     :  Number of past data points to include  
#           nR     :  Number of future data points to include  
#           nD     :  Derivitive Number (0 for smoothing)
#           nO     :  Order of smoothing polynomial
#               
#               


package provide TclUtils 1.0

proc TUsavgolCoef { Coef nC nL nR nD nO } {
 
   upvar $Coef C

   set T1 [expr $nR + $nL + 1] 
   set T2 [expr $nR + $nL] 
   if { ($nC < $T1) || ($nR < 0) || ($nL < 0) || ($T2 < $nO) } { return -1 }
         
   set EnD [expr $nO << 1] 
   set rLen [expr $nO + 1]

   for { set I 0 } { $I <= $EnD } { incr I } {
      if { $I == 0 } { set Sum 1.0 } else { set Sum 0.0 }
      for { set K 1 } { $K <= $nR } { incr K } {
         set Sum [expr $Sum + pow(double($K),double($I))]
      }
      for { set K 1 } { $K <= $nL } { incr K } {
         set Sum [expr $Sum + pow(double(-$K),double($I))]
      }
      set T1 [expr 2 * $nO - $I]
      if { $I < $T1 } { set M $I } else { set M $T1 }
      for { set K [expr -$M] } { $K <= $M } { incr K 2 } {
          set LoC [expr $rLen * (($I + $K)/2) + ($I - $K)/2]
          set A($LoC) $Sum
      }
   }

   set rV [TUmatrixLUD A $rLen Index]
   for { set I 0 } { $I <= $nO } { incr I } { set B($I) 0.0 }
   set B($nD) 1.0
   TUmatrixLUSub A $rLen Index B
   for { set I 0 } { $I < $nC } { incr I } { set C($I) 0.0 }
   for { set I [expr -$nL] } { $I <= $nR } { incr I } {
      set Sum $B(0)
      set Fac 1.0
      for { set J 1 } { $J <= $nO } { incr J } {
         set Fac [expr $Fac * $I] 
         set Sum [expr $Sum + $B($J) * $Fac]
      }
      set N [expr ($nC - $I) % $nC]
      set C($N) $Sum
   }
}
