package provide TclUtils 1.0

proc TUmatrixRot { Phi Theta Psi mT FmT { BeG 0 } } {
   global PI RtoD

   upvar $mT Z
    
   set cP [expr cos($Phi / $RtoD)]
   set sP [expr sin($Phi / $RtoD)]
   set cT [expr cos($Theta / $RtoD)]
   set sT [expr sin($Theta / $RtoD)]
   set cL [expr cos($Psi / $RtoD)]
   set sL [expr sin($Psi / $RtoD)]

   set I $BeG
   switch -exact -- $FmT {
      X  { 
         set Z($I)  1.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $cP ; incr I
         set Z($I)  $sP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I) [expr -$sP] ; incr I
         set Z($I)  $cP
      }
      X_T { 
         set Z($I)  1.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $cP ; incr I
         set Z($I) [expr -$sP] ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $sP ; incr I
         set Z($I)  $cP
      }
      Y  { 
         set Z($I)  $cP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $sP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  1.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I) [expr -$sP] ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $cP
      }
      Y_T { 
         set Z($I)  $cP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I) [expr -$sP] ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  1.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $sP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $cP
      }
      Z  { 
         set Z($I)  $cP ; incr I
         set Z($I)  $sP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I) [expr -$sP] ; incr I
         set Z($I)  $cP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  1.0
      }
      Z_T  { 
         set Z($I)  $cP ; incr I
         set Z($I) [expr -$sP] ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  $sP ; incr I
         set Z($I)  $cP ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  0.0 ; incr I
         set Z($I)  1.0
      }
      EULER {
         set Z($I) [expr  $cL * $cP - $cT * $sP * $sL] ; incr I
         set Z($I) [expr  $cL * $sP + $cT * $cP * $sL] ; incr I
         set Z($I) [expr  $sL * $sT] ; incr I
         set Z($I) [expr -$sL * $cP - $cT * $sP * $cL] ; incr I
         set Z($I) [expr -$sL * $sP + $cT * $cP * $cL] ; incr I
         set Z($I) [expr  $cL * $sT] ; incr I
         set Z($I) [expr  $sT * $sP] ; incr I
         set Z($I) [expr -$sT * $cP] ; incr I
         set Z($I) [expr $cT]
      } 
      EULER_T {
         set Z($I) [expr  $cL * $cP - $cT * $sP * $sL] ; incr I
         set Z($I) [expr -$sL * $cP - $cT * $sP * $cL] ; incr I
         set Z($I) [expr  $sT * $sP] ; incr I
         set Z($I) [expr  $cL * $sP + $cT * $cP * $sL] ; incr I
         set Z($I) [expr -$sL * $sP + $cT * $cP * $cL] ; incr I
         set Z($I) [expr -$sT * $cP] ; incr I
         set Z($I) [expr  $sT * $sL] ; incr I
         set Z($I) [expr  $sT * $cL] ; incr I
         set Z($I) [expr $cT]
      }
   }
}
