package provide TclUtils_C 1.0

# SOLVES  MATRIX A OPER MATRIX B -> MATRIX C

# A        - Matrix Input
# Action   - Operation
# B        - Matrix Input
# C        - Matrix Output
# Ra       - Rows in Matrix A
# Ca       - Columns in Matrix A
# Rb       - Rows in Matrix B
# Cb       - Columns in Matrix B

proc TUmatrixMath { A Action B C Ra Ca Rb Cb { Oa 0} { Ob 0} { Oc 0 } } {

   global RtoD

   upvar $A X
   upvar $B Y
   upvar $C Z

   set T 0.0
   switch -exact -- $Action {
      UNIT {  
         set aEnD [expr $Oc + $Ca * $Ra]
         set InC  [expr $Ra + 1]
         for { set I $Oc ; set J $Oc } { $I < $aEnD } { incr I } {
            if { $I == $J } {
               set Z($I) 1.0
               incr J $InC
            } else { set Z($I) 0.0 }
         }
      }

      TRANSPOSE {  
         set aEnD [expr $Oa + $Ra * $Ca]
         for { set I $Oa ; set J $Ob } { $I < $aEnD } { incr J } {
            set K [expr $J + $Oc]
            for { set L 0 } { $L < $Ca } { incr L; incr K $Ra ; incr I } {
                set Z($K) $X($I)
            }
         }
      }

      * {  
         set P $Oc
         set aEnD [expr $Oa + $Ra * $Ca]
         set bEnD [expr $Ob + $Rb * $Cb]
         set EnD  [expr $Ob + $Cb]
         for { set I $Oa } { $I < $aEnD } { incr I $Ca } {
             for { set J $Ob } { $J < $EnD } { incr J ; incr P } {
                set Z($P) 0.0
                set L $I
                for { set K $J } { $K < $bEnD } { incr K $Cb; incr L } { 
                   set Z($P) [expr $Z($P) + $X($L) * $Y($K)]
                }
             }
         }
      }
   }

   return $T
}
