#   Computes the EigenValues and EigenVectors of Matrix Mat

package provide TclUtils 1.0

proc TUmatrixEig { Mat N EigV EigVec } {

   upvar $Mat    A
   upvar $EigV   D
   upvar $EigVec V

   set EnD [expr $N * $N]
   set Skip [expr $N + 1]

   for { set I 0 ; set J 0; set K 0 } { $I < $EnD } { incr I } {
      if { $I == $K } {
         set V($I) 1.0
         set B($J) $A($I)
         set D($J) $A($I)
         set Z($J) 0.0
         incr J
         incr K $Skip
      } else { set V($I) 0.0 } 
   }

   set NRoT 0
   set EnD [expr $N - 1]
   for { set I 0 } { $I < 50 } { incr I } {
      set L 1
      set sM 0.0
      for { set J 0 ; set L 1 } { $J < $EnD } { incr J ; incr L} {
         for { set K $L } { $K < $N } { incr K } {
             set P [expr $N * $J + $K]
             set sM [expr $sM + abs($A($P))]
         }
      }

      if { $sM == 0.0 } { return $NRoT }
      if { $I < 3 } { 
         set Thres [expr 0.2 * $sM / $N / $N] 
      } else { set $Thres 0.0 }

      for { set J 0 ; set L 1 } { $J < $EnD } { incr J ; incr L} {
         for { set K $L } { $K < $N } { incr K } {
             set P [expr $N * $J + $K]
             set G [expr 100.0 * abs($A($P))]
             set T1 [expr (abs($D($J)) + $G) - abs($D($J))]
             set T2 [expr (abs($D($K)) + $G) - abs($D($K))]
             if { ($I > 3) && ($T1 == 0.0) && ($T2 == 0.0) } {
                set A($P) 0.0
             } elseif { [expr abs($A($P))] >  $Thres } {
                set H [expr $D($K) - $D($J)]
                set T1 [expr (abs($H) + $G) - abs($H)]
                if { $T1 == 0.0 } {
                   set T [expr $A($P) / $H ]
                } else {
                   set Th [expr 0.5 * $H / $A($P)]
                   set T [expr 1.0 /(abs($Th) + sqrt(1.0 + $Th * $Th))]
                   if { $Th < 0.0 } { set T [expr -$T] }
                }
                set C [expr 1.0 /sqrt(1.0 + $T * $T)]
                set S [expr $T * $C]
                set Tau [expr $S/(1.0 + $C)]
                set H [expr $T * $A($P)]
                set Z($J) [expr $Z($J) - $H]
                set Z($K) [expr $Z($K) + $H]
                set D($J) [expr $D($J) - $H]
                set D($K) [expr $D($K) + $H]
                set A($P) 0.0

		for { set T1 0 } { $T1 < $J } { incr T1 } {
                   set P1 [expr $N * $T1 + $J] 
                   set P2 [expr $N * $T1 + $K] 
                   set G $A($P1)
                   set H $A($P2)
                   set A($P1) [expr $G - $S * ( $H + $G * $Tau)]
                   set A($P2) [expr $H + $S * ( $G - $H * $Tau)]
                }
		for { set T1 $L } { $T1 < $K } { incr T1 } {
                   set P1 [expr $N * $J + $T1] 
                   set P2 [expr $N * $T1 + $K] 
                   set G $A($P1)
                   set H $A($P2)
                   set A($P1) [expr $G - $S * ( $H + $G * $Tau)]
                   set A($P2) [expr $H + $S * ( $G - $H * $Tau)]
                }
                set Beg [expr $K + 1]
		for { set T1 $Beg } { $T1 < $N } { incr T1 } {
                   set P1 [expr $N * $J + $T1] 
                   set P2 [expr $N * $K + $T1] 
                   set G $A($P1)
                   set H $A($P2)
                   set A($P1) [expr $G - $S * ( $H + $G * $Tau)]
                   set A($P2) [expr $H + $S * ( $G - $H * $Tau)]
                }
		for { set T1 0 } { $T1 < $N } { incr T1 } {
                   set P1 [expr $N * $T1 + $J] 
                   set P2 [expr $N * $T1 + $K] 
                   set G $V($P1)
                   set H $V($P2)
                   set V($P1) [expr $G - $S * ( $H + $G * $Tau)]
                   set V($P2) [expr $H + $S * ( $G - $H * $Tau)]
                }

                incr NRoT
            } 
         }
      }
      for { set J 0 } { $J < $N } { incr J } {
          set B($J) [expr $B($J) + $Z($J)]
          set D($J) $B($J)
          set Z($J) 0.0
      }
   }

   return $NRoT
}
