# GENERIC procedure to return the basis functions for a set of general 
#   Legendre polynomials.  nO is the order which is equivalent to Lmax.
#   X must be between -1 and 1.
#   This is taylored for use in TUdataLSq1D

package provide TclUtils 1.0

proc TUlgpFunc { X cM nO nC } {

   upvar $cM cF

   if { $nC <= 0 } {
      set nC 1;
      for { set I 1 } { $I <= $nO } { incr I } {
         set nC [expr $nC + 2 * $I - 1]
      }
   }

   set I 0

   for { set M 0 } { $M <= $nO } { incr M } {
      set cF($I) 1.0
      if { $M > 0 } { 
         set F [expr sqrt((1.0 + $X ) * (1.0 - $X))]
         set G 1.0
         for { set J 0 } { $J < $M } { incr J } {
            set cF($I) [expr -$cF($I) * $G * $F]
            set G [expr $G + 2.0]
         } 
      } 
      set J $I
      set K [expr $I - 1]
      incr I
      set N [expr $M + 1]
      for { set L $N } { $L <= $nO } { incr L } {
         if { $L == $N } {
            set cF($I) [expr $X * (2 * $M  + 1) * $cF($J) ] 
         } else {
            set dI [expr $L - $M]
            set cF($I) [expr ( $X * (2.0 * $L  - 1.0) * $cF($J) - \
                            ($L + $M - 1.0) * $cF($K) ) / $dI ]
         }
         incr I ; incr J ; incr K
      }
   }

   return $nC
}
