# GENERIC procedure to return the basis functions for a set of Legendre 
#   polynomials with m=0.  nC is the fit order + 1. This is taylored for 
#   use in TUdataLSq1D.

package provide TclUtils 1.0

proc TUlgp0Func { X cM nO nC } {

   upvar $cM cF

   set nC [expr $nO + 1] 

   set cF(0) 1.0 
   if { $nC >= 1 } { set cF(1) $X }
   if { $nC > 1 } { 
      set X2 [expr 2.0 * $X]
      set dX $X
      set J 1 
      set K 0 
      for { set I 2 } { $I < $nC } { incr I ; incr J ; incr K } {
          set dX [expr $dX + $X2]
          set cF($I) [expr ($dX * $cF($J) - $J * $cF($K))/$I] 
      }
   }

   return $nC
}
