#
#  Procedure
#    interate the trapazoidal integration over the function given by 
#
#          y = F($X)
#
#    until some convergence is reached
#
#  usage
#      set Value [TUintegTrapI FunC Beg End { ConV 1.0e-5} { MaxI 20 }  ]
#
#  parameter description
#     FunC     the function which determines intensity for a given X
#     Beg      start integration value
#     End      end integration value
#     N        Number of points added since last call to integral: 2**(N-2)
#     Conv     Convergence to within this range
#     MaxI     Maximum number of iterations
#     MinI     Minimum number of iterations before check

package provide TclUtils 1.0

proc TUintegTrapI { FunCNamE Beg End { ConV 1.0e-5 } { MaxI 20 } { MinI 5 } \
                    { DoOnce 0 } } {
   set pV 0.0
   set OldpV 0.0
   for { set I 1 } { $I <= $MaxI } { incr I } {
      set pV [TUintegTrap $FunCNamE $Beg $End $I $pV $DoOnce]
      if { $I > $MinI } {
         set dV [expr abs($pV - $OldpV)]  
         set cV [expr abs($ConV * $OldpV)]  
         if {($dV < $cV) || (($pV == 0.0) && ($OldpV == 0.0))} { return $pV }
      }
      set OldpV $pV
   }


   return [list $pV $dV]
}
