#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to initialize grid to
#         12:  Value used to indicate a bad grid point
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y

package provide TclUtils 1.0

proc TUgridNoise { Do Grid gInFo { V1 1 } { V2 0.0 } { V3 0.0 } } {
 
   upvar $Grid  G
   upvar $gInFo gI

   set nG [expr int($gI(4) * $gI(5))]
   switch -exact -- $Do {
      CUT  {
         for { set I 0 } { $I < $nG } { incr I } { 
            if { $G($I) != $gI(12) } {
               if { $G($I) <= $V1 } { set G($I) $V2 }
            }    
         }
      }
      UNIFORM  {
         for { set I 0 } { $I < $nG } { incr I } { 
            if { $G($I) != $gI(12) } {
               set G($I) [expr $G($I) - $V1]
               if { $G($I) < $V2 } { set G($I) $V3 }
            }    
         }
      }
      DESPECKLE  {
         for { set I 0 } { $I < $nG } { incr I } { 
            if { $G($I) != $gI(12) } {
               set EnD [TUgridInfo 41 gI gNum $I] 
               set CnT 0
               for { set J 0 } { $J < $EnD } { incr J } { 
                 if { $G($gNum($J)) > $V2 } { incr CnT }
               }
               if { $CnT <= $V1 } { set G($I) $V3 }
            }
         }
      }
   }
}
