#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to set unfilled grids to
#         12:  Bad grid value 
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y
#
#
#  Oper:  DUP - copy Grid1 to Grid3
#  Oper:  NORMALIZE - All elements in Grid1 are divided by the largest
#                     absolute value in the grid 

package provide TclUtils 1.0

proc TUgridMath { Grid1 Oper Grid2 Grid3 gInFo } {
 
   upvar $Grid1 G1
   upvar $Grid2 G2
   upvar $Grid3 G3
   upvar $gInFo gI

   set nG [ expr int($gI(4) * $gI(5)) ]
   switch -exact -- $Oper {
      DUP  {
         for { set I 0 } { $I < $nG } { incr I } { set G3($I) $G1($I) }
      }
      NORMALIZE  {
         set Max [expr abs($G1(0))]
         for { set I 1 } { $I < $nG } { incr I } { 
            set TsT [expr abs($G1($I))]
            if { $TsT > $Max } { set Max $TsT } 
         }
         for { set I 0 } { $I < $nG } { incr I } { 
            set G3($I) [expr $G1($I) / $Max] 
         }
      }
      GRADCY {
         set IncX [expr ($gI(1) - $gI(0)) / $gI(4)]
         set IncY [expr ($gI(3) - $gI(2)) / $gI(5)]
         set tIncX [expr 2.0 * $IncX]
         set tIncY [expr 2.0 * $IncY]
         for { set I 0 } { $I < $nG } { incr I } {
            set dX $tIncX
            set dY $tIncY
            TUgridInfo 20 gI rV $I
            set R $rI(3)
	    set nC [expr $rV(0) + 1]
	    set pC [expr $rV(0) - 1]
	    set nR [expr $rV(1) + 1]
	    set pR [expr $rV(1) - 1]
	    TUgridInfo 1 gI rA $nC $rV(1)
            if { $rA(0) < 0 } { set rA(0) $I ; set dX $IncX }
	    TUgridInfo 1 gI rB $pC $rV(1)
            if { $rB(0) < 0 } { set rB(0) $I ; set dX $IncX }
	    TUgridInfo 1 gI rC $rV(0) $nR
            if { $rC(0) < 0 } { set rC(0) $I ; set dY $IncY }
	    TUgridInfo 1 gI rD $rV(0) $pR
            if { $rD(0) < 0 } { set rD(0) $I ; set dY $IncY }

            set G2($I) [expr (($G1($rI(1)) - $G1($rI(0))) / $dX) / $R]
            set G3($I)dGdY [expr ($G1($rI(3)) - $G1($rI(2))) / $dY]
         }
      }

      GRAD {
         set IncX [expr ($gI(1) - $gI(0)) / $gI(4)]
         set IncY [expr ($gI(3) - $gI(2)) / $gI(5)]
         set tIncX [expr 2.0 * $IncX]
         set tIncY [expr 2.0 * $IncY]
         for { set I 0 } { $I < $nG } { incr I } {
            set dX $tIncX
            set dY $tIncY
	    TUgridInfo 20 gI rV $I
	    set nC [expr $rV(0) + 1]
	    set pC [expr $rV(0) - 1]
	    set nR [expr $rV(1) + 1]
	    set pR [expr $rV(1) - 1]
	    TUgridInfo 1 gI rA $nC $rV(1)
            if { $rA(0) < 0 } { set rA(0) $I ; set dX $IncX }
	    TUgridInfo 1 gI rB $pC $rV(1)
            if { $rB(0) < 0 } { set rB(0) $I ; set dX $IncX }
	    TUgridInfo 1 gI rC $rV(0) $nR
            if { $rC(0) < 0 } { set rC(0) $I ; set dY $IncY }
	    TUgridInfo 1 gI rD $rV(0) $pR
            if { $rD(0) < 0 } { set rD(0) $I ; set dY $IncY }

            set G2($I) [expr ($G1($rA(0)) - $G1($rB(0))) / $dX]
            set G3($I) [expr ($G1($rC(0)) - $G1($rD(0))) / $dY]
	    if { $rV(0) == 25 } {
	       set ya [expr $rV(3) + $IncY]
	       set yb [expr $rV(3) - $IncY]
	    }
         }
      }

      GRADRCY {
         set IncX [expr ($gI(1) - $gI(0)) / $gI(4)]
         set IncY [expr ($gI(3) - $gI(2)) / $gI(5)]
         set tIncX [expr 2.0 * $IncX]
         set tIncY [expr 2.0 * $IncY]
         for { set I 0 } { $I < $nG } { incr I } {
	    TUgridInfo 20 gI rV $I
            set R [expr sqrt($rV(2) * $rV(2) + $rV(3) * $rV(3))] 
            set AnG [expr atan2($rV(3), $rV(2))]
            set C [expr cos($AnG)]
            set S [expr sin($AnG)]
            set dX $tIncX
            set dY $tIncY

	    set nC [expr $rV(0) + 1]
	    set pC [expr $rV(0) - 1]
	    set nR [expr $rV(1) + 1]
	    set pR [expr $rV(1) - 1]
	    TUgridInfo 1 gI rA $nC $rV(1)
            if { $rA(0) < 0 } { set rA(0) $I ; set dX $IncX }
	    TUgridInfo 1 gI rB $pC $rV(1)
            if { $rB(0) < 0 } { set rB(0) $I ; set dX $IncX }
	    TUgridInfo 1 gI rC $rV(0) $nR
            if { $rC(0) < 0 } { set rC(0) $I ; set dY $IncY }
	    TUgridInfo 1 gI rD $rV(0) $pR
            if { $rD(0) < 0 } { set rD(0) $I ; set dY $IncY }

            set dGdX [expr ($G1($rA(0)) - $G1($rB(0))) / $dX]
            set dGdY [expr ($G1($rC(0)) - $G1($rD(0))) / $dY]

            set G2($I) [expr -$R * ($S * $dGdX - $C * $dGdY)]
            set G3($I) [expr $C * $dGdX + $S * $dGdY]
         }
      }

      +  -
      -  -
      *  {
         for { set I 0 } { $I < $nG } { incr I } {
             set G3($I) [expr $G1($I) $Oper $G2($I)] 
         }
      }

      /  {
         for { set I 0 } { $I < $nG } { incr I } {
             if { $G2($I) != 0.0 } {   
                set G3($I) [expr $G1($I) / $G2($I)] 
             } else { set G3($) $gI(12) }
         }
      }
   }
}
