#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to initialize grid to
#         12:  Value used to indicate a bad grid point
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y
# ReT
#        0 - V's real X,Y values
#            rInfo(0): grid number
#            rInfo(1): column number
#            rInfo(2): row number
#        1 - V's column, row number
#            rInfo(0): grid number
#       20 - V1 is grid number
#            rInfo(0): column number
#            rInfo(1): row number
#            rInfo(2): center grid X value
#            rInfo(3): center grid Y value
#       21 - V1 is grid number
#            rInfo(0): column number
#            rInfo(1): row number
#            rInfo(2): center grid X value
#            rInfo(3): center grid Y value
#            rInfo(4): middle right side X grid value 
#            rInfo(5): middle right side Y grid value 
#            rInfo(6): upper right corner X grid value 
#            rInfo(7): upper right corner Y grid value 
#            rInfo(8): middle upper X grid value 
#            rInfo(9): middle upper Y grid value 
#            rInfo(10): upper left corner X grid value 
#            rInfo(11): upper left corner Y grid value 
#            rInfo(12): middle left side X grid value 
#            rInfo(13): middle left side Y grid value 
#            rInfo(14): lower left corner X grid value 
#            rInfo(15): lower left corner Y grid value 
#            rInfo(16): middle lower X grid value 
#            rInfo(17): middle lower Y grid value 
#            rInfo(18): lower right corner X grid value 
#            rInfo(19): lower right corner Y grid value 
#       22 - V grid number
#            rInfo(0): lower left corner X grid value 
#            rInfo(1): lower left corner Y grid value 
#            rInfo(2): upper right corner X grid value 
#            rInfo(3): upper right corner Y grid value 
#       30 - No V1 or V2  - returns sequential X edges of all cells in a
#                           grid row
#       31 - No V1 or V2  - returns sequential Y edges of all cells in a
#                           grid column
#       32 - No V1 or V2  - returns X centers of all cells in a grid row
#       33 - No V1 or V2  - returns Y centers of all cells in a grid column
#       40 - V1 is grid number and V2 is value such that 2 * $V2 + 1 is the 
#                length of square of grids centered  on V1
#            rInfo(0): beginning Column number of square
#            rInfo(1): ending Column number of square
#            rInfo(2): beginning Row number of square
#            rInfo(3): ending Row number of square
#       41 - V1 is grid number and V2 is value such that 2 * $V2 + 1 is the 
#                length of square of grids centered  on V1
#            rInfo(0-N): grid numbers in outer ring of grids in square of 
#                grids centerd on $V1

package provide TclUtils 1.0

proc TUgridInfo { ReT gInFo rInFo { V1 0 } { V2 1 } } {
 
   upvar $gInFo gI
   upvar $rInFo rI

   set nG [expr int($gI(4) * $gI(5))]

   if [info exists gI(17)] {
      set xLog [string match LOG $gI(17)]
   } else { set xLog 0 }
   if [info exists gI(18)] {
      set yLog [string match LOG $gI(18)]
   } else { set yLog 0 }

   if $xLog {
      set gXa [expr log10($gI(0))]
      set gXb [expr log10($gI(1))]
      if { $ReT == 0 } { set V1 [expr log10($V1)] }
   } else { set gXa $gI(0) ; set gXb $gI(1) }

   if $yLog {
      set gYa [expr log10($gI(2))]
      set gYb [expr log10($gI(3))]
      if { $ReT == 0 } { set V2 [expr log10($V2)] }
   } else { set gYa $gI(2) ; set gYb $gI(3) }

   if { $ReT < 40 } {
      set IncX [expr ($gXb - $gXa) / $gI(4)]
      set IncY [expr ($gYb - $gYa) / $gI(5)]
   }

   if { $ReT >= 20 } {
      if { ($V1 < 0) || ($V1 >= $nG) } { return 0 }
      if [string match ROW $gI(8)] { 
         set R [expr $V1 / $gI(4)] 
         set C [expr $V1 % int($gI(4))] 
         set Ax 1 ; set Ay $gI(4)
      } else {
         set C [expr $V1 / $gI(5)] 
         set R [expr $V1 % int($gI(5))] 
         set Ay 1 ; set Ax $gI(5)
      }
   }

   switch -exact -- $ReT {
      0  {
         set rI(1) [expr int(($V1 - $gXa) / $IncX) ]
         if [string match YES $gI(15)] { set rI(1) [expr $rI(1) % $gI(4)] }
         set rI(2) [expr int(($V2 - $gYa) / $IncY) ]
         if [string match YES $gI(16)] { set rI(2) [expr $rI(2) % $gI(5)] }
         if { ($rI(1) < $gI(4)) && ($rI(2) < $gI(5)) && \
                                   ($rI(1) >= 0) && ($rI(2) >= 0) } {
            if [string match COLUMN $gI(8)] {
               set rI(0) [expr int($rI(1) * $gI(5) + $rI(2))]
            } else { set rI(0) [expr int($rI(2) * $gI(4) + $rI(1))] }
         } else { set rI(0) -1 }
         set rV 3
      }
      1  {
         if [string match YES $gI(15)] { set V1 [expr ($V1 + $gI(4)) % $gI(4)] }
         if [string match YES $gI(16)] { set V2 [expr ($V2 + $gI(5)) % $gI(5)] }
         if { ($V1 < $gI(4)) && ($V2 < $gI(5)) && ($V1 >= 0) && ($V2 >= 0) } {
            if [string match COLUMN $gI(8)] {
               set rI(0) [expr int($V1 * $gI(5) + $V2)]
            } else { set rI(0) [expr int($V2 * $gI(4) + $V1)] }
         } else { set rI(0) -1 }
         set rV 1
      }

      20 {
         set rI(0) $C
         set rI(1) $R
	 if $xLog {
            set rI(2) [expr pow(10.0, ($C + .5) * $IncX + $gXa)]
	 } else { set rI(2) [expr ($C + .5) * $IncX + $gXa] }
	 if $yLog {
            set rI(3) [expr pow(10.0, ($R + .5) * $IncY + $gYa)]
	 } else { set rI(3) [expr ($R + .5) * $IncY + $gYa] }
         set rV 4
      }

      21 {
         set rI(0) $C
         set rI(1) $R
	 if $xLog {
            set rI(2)  [expr pow(10.0, ($C + 0.5) * $IncX + $gXa)]
            set rI(6)  [expr pow(10.0, ($C + 1.0) * $IncX + $gXa)]
            set rI(14) [expr pow(10.0, $C * $IncX + $gXa)]
	 } else {
            set rI(2)  [expr ($C + 0.5) * $IncX + $gXa]
            set rI(6)  [expr ($C + 1.0) * $IncX + $gXa]
            set rI(14) [expr $C * $IncX + $gXa]
	 }
	 if $yLog {
            set rI(3)  [expr pow(10.0, ($R + 0.5) * $IncY + $gYa)]
            set rI(7)  [expr pow(10.0, ($R + 1.0) * $IncY + $gYa)]
            set rI(15) [expr pow(10.0, $R * $IncY + $gYa)]
	 } else {
            set rI(3)  [expr ($R + 0.5) * $IncY + $gYa]
            set rI(7)  [expr ($R + 1.0) * $IncY + $gYa]
            set rI(15) [expr $R * $IncY + $gYa]
	 }

         set rI(4)  $rI(6)  ; set rI(5)  $rI(3)
         set rI(8)  $rI(2)  ; set rI(9)  $rI(7)
         set rI(10) $rI(14) ; set rI(11) $rI(7)
         set rI(12) $rI(14) ; set rI(13) $rI(3)
         set rI(16) $rI(2)  ; set rI(17) $rI(15)
         set rI(18) $rI(6)  ; set rI(19) $rI(15)
         set rV 20
      }

      22 {
	 if $xLog {
            set rI(0) [expr pow(10.0, $C * $IncX + $gXa)]
            set rI(2) [expr pow(10.0, ($C + 1.0) * $IncX + $gXa)]
	 } else {
            set rI(0) [expr $C * $IncX + $gXa]
            set rI(2) [expr ($C + 1.0) * $IncX + $gXa]
	 }
	 if $yLog {
            set rI(1) [expr pow(10.0, $R * $IncY + $gYa)]
            set rI(3) [expr pow(10.0, ($R + 1.0) * $IncY + $gYa)]
	 } else {
            set rI(1) [expr $R * $IncY + $gYa]
            set rI(3) [expr ($R + 1.0) * $IncY + $gYa]
	 }
	 set rV 4
      }

      30 { 
         if $xLog {
            for { set I 0 } { $I <= $gI(4) } { incr I } {
               set rI($I) [expr pow(10.0, $gXa +  $I * $IncX)]
            }
         } else { 
            for { set I 0 } { $I <= $gI(4) } { incr I } {
               set rI($I) [expr $gXa +  $I * $IncX]
            }
	 }
         set rV [expr $gI(4) + 1]
      }
      31 {
         if $yLog {
            for { set I 0 } { $I <= $gI(5) } { incr I } {
               set rI($I) [expr pow(10.0, $gYa +  $I * $IncY)]
            }
	 } else {
            for { set I 0 } { $I <= $gI(5) } { incr I } {
               set rI($I) [expr $gYa +  $I * $IncY]
            }
         }
         set rV [expr $gI(5) + 1]
      }
      32 { 
         if $xLog {
            for { set I 0 } { $I <= $gI(4) } { incr I } {
               set rI($I) [expr pow(10.0, $gXa +  ($I + .5) * $IncX)]
            }
	 } else {
            for { set I 0 } { $I <= $gI(4) } { incr I } {
               set rI($I) [expr $gXa +  ($I + .5) * $IncX]
            }
	 }
         set rV $gI(4)
      }
      33 {
         if $yLog {
            for { set I 0 } { $I <= $gI(5) } { incr I } {
               set rI($I) [expr pow(10.0, $gYa +  ($I + .5) * $IncY)]
            }
	 } else {
            for { set I 0 } { $I <= $gI(5) } { incr I } {
               set rI($I) [expr $gYa +  ($I + .5) * $IncY]
            }
	 }
         set rV $gI(5)
      }

      40 {
         set rB [expr $R - $V2]
         set rE [expr $R + $V2]
         set cB [expr $C - $V2]
         set cE [expr $C + $V2]
         if [string match NO $gI(15)] {
            if { $cB >= 0 } { 
               set CoL [expr ($gI(4) + $cB) % $gI(4)] 
               set rI(0) [ expr $Ax * $CoL + $Ay * (($R + $gI(5)) % $gI(5))] 
            } else { set rI(0) -1 }
            if { $cE < $gI(4) } {
               set CoL [expr ($gI(4) + $cE) % $gI(4)] 
               set rI(1) [ expr $Ax * $CoL + $Ay * (($R + $gI(5)) % $gI(5))] 
            } else { set rI(1) -1 }
         } else {
            set CoL [expr ($gI(4) + $cB) % $gI(4)] 
            set rI(0) [ expr $Ax * $CoL + $Ay * (($R + $gI(5)) % $gI(5))] 
            set CoL [expr ($gI(4) + $cE) % $gI(4)] 
            set rI(1) [ expr $Ax * $CoL + $Ay * (($R + $gI(5)) % $gI(5))] 
         }

         if [string match NO $gI(16)] { 
            if { $rB >= 0 } { 
               set RoW [expr ($gI(5) + $rB) % $gI(5)] 
               set rI(2) [ expr $Ay * $RoW + $Ax * (($C + $gI(4)) % $gI(4))] 
            } else { set rI(2) -1 }
            if { $rE < $gI(5) } {
               set RoW [expr ($gI(5) + $rE) % $gI(5)] 
               set rI(3) [ expr $Ay * $RoW + $Ax * (($C + $gI(4)) % $gI(4))] 
            } else { set rI(3) -1 }
         } else {
             set RoW [expr ($gI(5) + $rB) % $gI(5)] 
             set rI(2) [ expr $Ay * $RoW + $Ax * (($C + $gI(4)) % $gI(4))] 
             set RoW [expr ($gI(5) + $rE) % $gI(5)] 
             set rI(3) [ expr $Ay * $RoW + $Ax * (($C + $gI(4)) % $gI(4))] 
         }

         set rV 4
      }

      41 {
         set rV 0
         set rB [expr $R - $V2]
         set rE [expr $R + $V2]
         set cB [expr $C - $V2]
         set cE [expr $C + $V2]
         set cBn [expr $cB + 1]
         set cEn [expr $cE - 1]
         set rH -1
         if [string match NO $gI(16)] { 
            if { $rB < 0 } { set rB 0 ; set rH $rE }
            if { $rE >= $gI(5) } { set rE [expr $gI(5) - 1] ; set rH $rB }
         } 
         set cH -1
         if [string match NO $gI(15)] {
            if { $cB < 0 } { set cB 0 ; set cH $cE ; set cBn 0}
            if { $cE >= $gI(4) } { 
                set cE [expr $gI(4) - 1] 
                set cH $cB 
                set cEn $cE
            }
         }

         if { $cH < 0 } {
            set C1 [expr ($gI(4) + $cB) % $gI(4)] 
            set C2 [expr ($gI(4) + $cE) % $gI(4)] 
            for { set I $rB } { $I <= $rE } { incr I } { 
               set rI($rV) [ expr $Ax * $C1 + $Ay * (($I + $gI(5)) % $gI(5))] 
               incr rV
               set rI($rV) [ expr $Ax * $C2 + $Ay * (($I + $gI(5)) % $gI(5))] 
               incr rV
            }
         } else {
            set C1 [expr ($gI(4) + $cH) % $gI(4)] 
            for { set I $rB } { $I <= $rE } { incr I } { 
               set rI($rV) [ expr $Ax * $C1 + $Ay * (($I + $gI(5)) % $gI(5))] 
               incr rV
            }
         }

         if { $rH < 0 } {
            set C1 [expr ($gI(5) + $rB) % $gI(5)] 
            set C2 [expr ($gI(5) + $rE) % $gI(5)] 
            for { set I $cBn } { $I <= $cEn } { incr I } { 
               set rI($rV) [ expr $Ay * $C1 + $Ax * (($I + $gI(4)) % $gI(4))] 
               incr rV
               set rI($rV) [ expr $Ay * $C2 + $Ax * (($I + $gI(4)) % $gI(4))] 
               incr rV
            }
         } else {
            set C1 [expr ($gI(5) + $rH) % $gI(5)] 
            for { set I $cBn } { $I <= $cEn } { incr I } { 
               set rI($rV) [ expr $Ay * $C1 + $Ax * (($I + $gI(4)) % $gI(4))] 
               incr rV
            }
         }
      }
      42 {
         set rV 0
         set rB [expr $R - $V2]
         set rE [expr $R + $V2]
         set cB [expr $C - $V2]
         set cE [expr $C + $V2]
         set cBn [expr $cB + 1]
         set cEn [expr $cE - 1]
         set rH -1
         if [string match NO $gI(16)] { 
            if { $rB < 0 } { set rB 0 ; set rH $rE }
            if { $rE >= $gI(5) } { set rE [expr $gI(5) - 1] ; set rH $rB }
         } 
         set cH -1
         if [string match NO $gI(15)] {
            if { $cB < 0 } { set cB 0 ; set cH $cE ; set cBn 0}
            if { $cE >= $gI(4) } { 
                set cE [expr $gI(4) - 1] 
                set cH $cB 
                set cEn $cE
            }
         }

         if { $cH < 0 } {
            set C1 [expr ($gI(4) + $cB) % $gI(4)] 
            set C2 [expr ($gI(4) + $cE) % $gI(4)] 
            set dC1 [expr $C - $cB]
            set dC2 [expr $C - $cE]
            for { set I $rB } { $I <= $rE } { incr I } { 
               set dR [expr $R - $I]
               set rI($rV) [ expr $Ax * $C1 + $Ay * (($I + $gI(5)) % $gI(5))] 
               incr rV
               set rI($rV) [ expr $dC1 * $dC1 + $dR * $dR] 
               incr rV
               set rI($rV) [ expr $Ax * $C2 + $Ay * (($I + $gI(5)) % $gI(5))] 
               incr rV
               set rI($rV) [ expr $dC2 * $dC2 + $dR * $dR] 
               incr rV
            }
         } else {
            set C1 [expr ($gI(4) + $cH) % $gI(4)] 
            set dC1 [expr $C - $cH]
            for { set I $rB } { $I <= $rE } { incr I } { 
               set dR [expr $R - $I]
               set rI($rV) [ expr $Ax * $C1 + $Ay * (($I + $gI(5)) % $gI(5))] 
               incr rV
               set rI($rV) [ expr $dC1 * $dC1 + $dR * $dR] 
               incr rV
            }
         }

         if { $rH < 0 } {
            set C1 [expr ($gI(5) + $rB) % $gI(5)] 
            set C2 [expr ($gI(5) + $rE) % $gI(5)] 
            set dR1 [expr $R - $rB]
            set dR2 [expr $R - $rE]
            for { set I $cBn } { $I <= $cEn } { incr I } { 
               set dC [expr $R - $I]
               set rI($rV) [ expr $Ay * $C1 + $Ax * (($I + $gI(4)) % $gI(4))] 
               incr rV
               set rI($rV) [ expr $dR1 * $dR1 + $dC * $dC] 
               incr rV
               set rI($rV) [ expr $Ay * $C2 + $Ax * (($I + $gI(4)) % $gI(4))] 
               incr rV
               set rI($rV) [ expr $dR2 * $dR2 + $dC * $dC] 
               incr rV
            }
         } else {
            set C1 [expr ($gI(5) + $rH) % $gI(5)] 
            set dR1 [expr $R - $rH]
            for { set I $cBn } { $I <= $cEn } { incr I } { 
               set dC [expr $R - $I]
               set rI($rV) [ expr $Ay * $C1 + $Ax * (($I + $gI(4)) % $gI(4))] 
               incr rV
               set rI($rV) [ expr $dR1 * $dR1 + $dC * $dC] 
               incr rV
            }
         }
      }
   }

   return $rV
}
