#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to set unfilled grids to
#         12:  Bad grid value 
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y
#         17:  X Scaling
#         18:  Y Scaling
#

#  INPUTS
#    Fmt   : 2DFILTER, SAVITZKYGOLAY
#    Grid  : The data grid
#    gInfo : The data grid definition parameters
#    oPs   : Smoothing options.  These depend on Fmt
#            2DFILTER:  Scalar value giving the smoothing filter to use 
#                            0 - 3x3 Low Pass Filter (Smoothing)
#                            1 - 5x5 Low Pass Filter (Smoothing)
#                            2 - 3x3 High Pass Filter (Sharpening)
#                            3 - 5x5 High Pass Filter (Sharpening)
#                            4 - 3x3 Laplacian Filter
#                            5 - 5x5 Laplacian Filter
#                            6 - Robert's Filter
#                            default -
#            SAVITZKYSOLAY:  0 - Smooth ROW or COLUMN 
#                            1 - Set Empty grids to this value or NO to skip
#                            2 - Set Bad grids to this value or NO to skip
#                            3 - Past data points to include in filter
#                            4 - Future data points to include in filter
#                            5 - Filter order
#                            6 - Refill end contamination YES, NO, or value
#            CONTRAHARMONIC  0 - Mask size of the filtered region (< 12 ; odd)
#                            1 - Filter Order
#
#    Smooth:  User defined 2D smoothing filter

package provide TclUtils 1.0

proc TUgridFilter { Fmt Grid gInFo sOp { Filter "" } } {
 
   upvar $Grid G
   upvar $gInFo gI
   upvar $sOp oP

# SWITCH on the filter type. 

   switch -exact -- $Fmt {
      2DFILTER {
         if { [string length $Filter] == 0 } {
            switch -exact -- $oP(0) {
               0  {  set fE [list 1.0  2.0  1.0 \
	                          2.0  4.0  2.0 \
		                  1.0  2.0  1.0 ]
               }
               1  {  set fE [list 1.0  1.0   1.0  1.0  1.0 \
		                  1.0  4.0   4.0  4.0  1.0 \
		                  1.0  4.0  12.0  4.0  1.0 \
                                  1.0  4.0   4.0  4.0  1.0 \
                                  1.0  1.0   1.0  1.0  1.0 ]
               }
               2  {  set fE [list -1.0  -1.0  -1.0 \
	                          -1.0   9.0  -1.0 \
		                  -1.0  -1.0  -1.0 ]
               }
               3  {  set fE [list  0.0  -1.0   -1.0  -1.0   0.0 \
		                  -1.0   2.0   -4.0   2.0  -1.0 \
		                  -1.0  -4.0   13.0  -4.0  -1.0 \
                                  -1.0   2.0   -4.0   2.0  -1.0 \
                                   0.0  -1.0   -1.0  -1.0   0.0 ]
               }
               4  {  set fE [list  0.0  -1.0   0.0 \
	                          -1.0   4.0  -1.0 \
		                   0.0  -1.0   0.0 ]
               }
               5  {  set fE [list -1.0  -1.0   -1.0  -1.0  -1.0 \
		                  -1.0   1.0   -1.0   1.0  -1.0 \
		                  -1.0  -1.0   24.0  -1.0  -1.0 \
                                  -1.0   1.0   -1.0   1.0  -1.0 \
                                  -1.0  -1.0   -1.0  -1.0  -1.0 ]
               }
               6  {  set fE [list  0.0  -1.0 \
	                          -1.0   0.0 ]
               }
               default  {  set fE [list 1.0  2.0  1.0 \
	                                2.0  4.0  2.0 \
		                        1.0  2.0  1.0 ]
               }
            }

# NORMALIZE the filter if needed

	    set SuM 0.0
	    set nE [llength $fE]
	    for { set I 0 } { $I < $nE } { incr I } {
	       set F($I) [lindex $fE $I]
	       set SuM [expr $SuM + $F($I)]
	    }
            if { $SuM > 0.0 } {
	       for { set I 0 } { $I < $nE } { incr I } {
	          set F($I) [expr $F($I) / $SuM]
	       }
            }
         } else { upvar $Filter F }

#  THESE are all square filters (MXM) so knowing the size tells all

         set sLen [expr int(sqrt([array size F]))]
         if { [expr $sLen % 2] == 0 } { return -1 }
         set BuF  [expr ($sLen - 1) / 2 ]

#  FOR a cyclic axis there are no edges to worry about but for non-cyclic
#    axis there is a buffer in which we can't smooth

         if [string match NO $gI(15)] { 
            set XStart $BuF ; set XEnd [expr $gI(4) - $BuF]
         } else { set XStart 0 ; set XEnd $gI(4) }

         if [string match NO $gI(16)] { 
            set YStart $BuF ; set YEnd [expr $gI(5) - $BuF]
         } else { set YStart 0 ; set YEnd $gI(5) }

#  COPY the grid to a temporary grid.  The original is overwritten in the
#    smoothing.

         set TotGrids [ expr $gI(4) * $gI(5) ]
         for { set I 0 } { $I < $TotGrids } { incr I } { set tG($I) $G($I) }

#  OK - Do the smoothing

         for { set X $XStart } { $X < $XEnd } { incr X } { 
            set CStart [expr $X - $BuF]
            set CEnd   [expr $X + $BuF]
            for { set Y $YStart } { $Y < $YEnd } { incr Y } { 
               set RStart [expr $Y - $BuF]
               set REnd   [expr $Y + $BuF]
               set Sum 0.0
               set I 0
               for { set R $RStart } { $R <= $REnd } { incr R } { 
                  for { set C $CStart } { $C <= $CEnd } { incr C } { 
                     TUgridInfo 1 gI gN $C $R
                     set Sum [expr $Sum + $tG($gN(0)) * $F($I)]
                     incr I
                  }
               }
               TUgridInfo 1 gI gN $X $Y
               set G($gN(0)) $Sum
            }
         }
      }

      SAVITZKYGOLAY {
        set fOp(0) $oP(3) ; set fOp(1) $oP(4) ; set fOp(2) $oP(5)
        if [string match ROW $oP(0)] { set nE $gI(4) } else { set nE $gI(5) }
        for { set I 0 } { $I < $nE } { incr I } {
           set nV [TUgridRowCol G gI rC RETRIEVE $oP(0) $I $oP(1) $oP(2) 0.0]
           TUdataFilter rC $nV SAVITZKYGOLAY fOp fV 
           if { ![string match NO $oP(6)] } { 
              if { [string match YES $oP(6)] } { 
                 for { set J 0 } { $J < $oP(3) } { incr J } {set fV($J) $rC($J)}
                 set J [expr $nV - $oP(4)] 
                 for {  } { $J < $nV } { incr J } { set fV($J) $rC($J) }
              } else {
                 for { set J 0 } { $J < $oP(3) } { incr J } {set fV($J) $oP(6)}
                 set J [expr $nV - $oP(4)] 
                 for {  } { $J < $nV } { incr J } { set fV($J) $oP(6) }
              } 
           }
           TUgridRowCol G gI fV STORE $oP(0) $I
        }
      }
   }

   return 1
}
