#  gInFo - Grid Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW and ADD (initialize) or ADD ( just add to) grid or  
#              ADDEND  ADD (add to and normalize) grid or END   
#         11:  Value to set unfilled grids to
#         12:  Bad grid value 
#         13:  Remove data below this value
#         14:  Remove data above this value
#         15:  Cyclic in X
#         16:  Cyclic in Y

package provide TclUtils 1.0

proc TUgridCut { Grid gInFo X1 Y1 X2 Y2 nP Cv Rv Vv { Expand 1} \
                 { InC  -1 } } {
 
   upvar $Grid G
   upvar $gInFo gI
   upvar $Cv Xv 
   upvar $Rv Yv 
   upvar $Vv Zv 

# SET up the parametric X and Y unit vectors along the requested cut.  

   set dX [expr $X2 - $X1]
   set dY [expr $Y2 - $Y1]
   set Phi [expr atan2($dY, $dX)]

# NOW can we take the user end points at face value or do we need to expand
#   (or contract) them so that they fall on a grid edge.
#
# REMEMBER to recalculate the angle since the line ends could be turned
#    around in all this and the line vector needs to point from X1,Y1
#    to X2,Y2

   if {$Expand == 1 } {
      if { $dY == 0 } {
         set X1 $gI(0)
         set X2 $gI(1)
      } elseif { $dX == 0 } {
         set Y1 $gI(2)
         set Y2 $gI(3)
      } else {
         set A [expr $dY / $dX]
	 set B [expr $Y1 - $A * $X1] 

         if { $gI(0) > $gI(1) } {
              set Xmx $gI(0)
              set Xmn $gI(1)
         } else { set Xmx $gI(1) ; set Xmn $gI(0) } 
         if { $gI(2) > $gI(3) } {
              set Ymx $gI(2)
              set Ymn $gI(3)
         } else { set Ymx $gI(3) ; set Ymn $gI(2) } 

	 set yT [expr $gI(0) * $A + $B]
	 if { ($yT > $Ymn) && ($yT < $Ymx) } {
	    set X1 $gI(0)
	    set Y1 $yT
         } else {
	    set Y1 $gI(2)
	    set X1 [expr ($gI(2) - $B) / $A]
         }

	 set yT [expr $gI(1) * $A + $B]
	 if { ($yT > $Ymn) && ($yT < $Ymx) } {
	    set X2 $gI(1)
	    set Y2 $yT
         } else {
	    set Y2 $gI(3)
	    set X2 [expr ($gI(3) - $B) / $A]
         }
      }
      set dX [expr $X2 - $X1]
      set dY [expr $Y2 - $Y1]
      set Phi [expr atan2($dY, $dX)]
   }

   set Xo $X1
   set Yo $Y1

# SET the step size along the cut.  This is only done if the user hasn't
#    already defined it 

   set D [expr sqrt($dX * $dX + $dY * $dY)]
   if { $InC <= 0.0 } {
      set InC [expr $D / ($nP - 1.0) ]
   } else { set nP [expr int($D / $InC) + 1)]  }

# LOOP over the cut locations. 

   set D 0.0
   set nV 0
   for { set I 0 } { $I < $nP } { incr I ; set D [expr $D + $InC] } {
      set X [expr $D * cos($Phi) + $Xo]
      set Y [expr $D * sin($Phi) + $Yo]
      TUgridInfo 0 gI rI $X $Y
      if { $rI(0) > 0 } {
          set Xv($nV) $X
          set Yv($nV) $Y
          set Zv($nV) $G($rI(0))
          incr nV
      }
   }

   return [list $nV $X1 $Y1 $X2 $Y2]
}
